/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownCommandResponseException;
import org.eclipse.ditto.protocol.mapper.AbstractQuerySignalMapper;
import org.eclipse.ditto.protocol.mapper.ResponseSignalMapper;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveThingsResponse;

final class RetrieveThingsResponseSignalMapper
extends AbstractQuerySignalMapper<RetrieveThingsResponse>
implements ResponseSignalMapper {
    RetrieveThingsResponseSignalMapper() {
    }

    @Override
    void validate(RetrieveThingsResponse commandResponse, TopicPath.Channel channel) {
        String responseName = commandResponse.getClass().getSimpleName().toLowerCase();
        if (!responseName.endsWith("response")) {
            throw (UnknownCommandResponseException)UnknownCommandResponseException.newBuilder(responseName).build();
        }
    }

    @Override
    TopicPathBuilder getTopicPathBuilder(RetrieveThingsResponse command) {
        String namespace = command.getNamespace().orElse("_");
        return ProtocolFactory.newTopicPathBuilderFromNamespace(namespace);
    }

    @Override
    void enhancePayloadBuilder(RetrieveThingsResponse commandResponse, PayloadBuilder payloadBuilder) {
        payloadBuilder.withStatus(commandResponse.getHttpStatus());
        payloadBuilder.withValue(commandResponse.getEntity(commandResponse.getImplementedSchemaVersion()));
    }
}

