/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import org.eclipse.ditto.policies.model.signals.commands.query.PolicyQueryCommandResponse;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownCommandResponseException;
import org.eclipse.ditto.protocol.mapper.AbstractQuerySignalMapper;
import org.eclipse.ditto.protocol.mapper.ResponseSignalMapper;

final class PolicyQueryResponseSignalMapper
extends AbstractQuerySignalMapper<PolicyQueryCommandResponse<?>>
implements ResponseSignalMapper {
    PolicyQueryResponseSignalMapper() {
    }

    @Override
    void validate(PolicyQueryCommandResponse<?> commandResponse, TopicPath.Channel channel) {
        String responseName = commandResponse.getClass().getSimpleName().toLowerCase();
        if (!responseName.endsWith("response")) {
            throw (UnknownCommandResponseException)UnknownCommandResponseException.newBuilder(responseName).build();
        }
    }

    @Override
    TopicPathBuilder getTopicPathBuilder(PolicyQueryCommandResponse<?> command) {
        return ProtocolFactory.newTopicPathBuilder(command.getEntityId()).policies();
    }

    @Override
    void enhancePayloadBuilder(PolicyQueryCommandResponse<?> commandResponse, PayloadBuilder payloadBuilder) {
        payloadBuilder.withStatus(commandResponse.getHttpStatus());
        payloadBuilder.withValue(commandResponse.getEntity(commandResponse.getImplementedSchemaVersion()));
    }
}

