/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import org.eclipse.ditto.policies.model.signals.commands.modify.PolicyModifyCommandResponse;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownCommandResponseException;
import org.eclipse.ditto.protocol.mapper.AbstractModifySignalMapper;
import org.eclipse.ditto.protocol.mapper.ResponseSignalMapper;

final class PolicyModifyResponseSignalMapper
extends AbstractModifySignalMapper<PolicyModifyCommandResponse<?>>
implements ResponseSignalMapper {
    PolicyModifyResponseSignalMapper() {
    }

    @Override
    void validate(PolicyModifyCommandResponse<?> commandResponse, TopicPath.Channel channel) {
        String responseName = commandResponse.getClass().getSimpleName().toLowerCase();
        if (!responseName.endsWith("response")) {
            throw (UnknownCommandResponseException)UnknownCommandResponseException.newBuilder(responseName).build();
        }
    }

    @Override
    TopicPathBuilder getTopicPathBuilder(PolicyModifyCommandResponse<?> command) {
        return ProtocolFactory.newTopicPathBuilder(command.getEntityId()).policies();
    }

    @Override
    void enhancePayloadBuilder(PolicyModifyCommandResponse<?> commandResponse, PayloadBuilder payloadBuilder) {
        payloadBuilder.withStatus(commandResponse.getHttpStatus());
        commandResponse.getEntity(commandResponse.getImplementedSchemaVersion()).ifPresent(payloadBuilder::withValue);
    }
}

