/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.policies.model.signals.events.PolicyEvent;
import org.eclipse.ditto.protocol.EventsTopicPathBuilder;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownChannelException;
import org.eclipse.ditto.protocol.UnknownEventException;
import org.eclipse.ditto.protocol.mapper.AbstractSignalMapper;

final class PolicyEventSignalMapper
extends AbstractSignalMapper<PolicyEvent<?>> {
    PolicyEventSignalMapper() {
    }

    @Override
    void enhancePayloadBuilder(PolicyEvent<?> signal, PayloadBuilder payloadBuilder) {
        payloadBuilder.withRevision(signal.getRevision()).withTimestamp(signal.getTimestamp().orElse(null));
        Optional value = signal.getEntity(signal.getDittoHeaders().getSchemaVersion().orElse(signal.getLatestSchemaVersion()));
        value.ifPresent(payloadBuilder::withValue);
    }

    @Override
    DittoHeaders enhanceHeaders(PolicyEvent<?> signal) {
        Optional value = signal.getEntity(signal.getDittoHeaders().getSchemaVersion().orElse(signal.getLatestSchemaVersion()));
        if (value.isPresent()) {
            return ProtocolFactory.newHeadersWithJsonContentType((Map<String, String>)signal.getDittoHeaders());
        }
        return signal.getDittoHeaders();
    }

    @Override
    TopicPath getTopicPath(PolicyEvent<?> signal, TopicPath.Channel channel) {
        EventsTopicPathBuilder topicPathBuilder = PolicyEventSignalMapper.getEventsTopicPathBuilderOrThrow(signal, channel);
        String eventName = PolicyEventSignalMapper.getLowerCaseEventName(signal);
        if (PolicyEventSignalMapper.isAction(eventName, TopicPath.Action.CREATED)) {
            topicPathBuilder.created();
        } else if (PolicyEventSignalMapper.isAction(eventName, TopicPath.Action.MODIFIED)) {
            topicPathBuilder.modified();
        } else if (PolicyEventSignalMapper.isAction(eventName, TopicPath.Action.DELETED)) {
            topicPathBuilder.deleted();
        } else if (PolicyEventSignalMapper.isAction(eventName, TopicPath.Action.MERGED)) {
            topicPathBuilder.merged();
        } else {
            throw (UnknownEventException)UnknownEventException.newBuilder(eventName).build();
        }
        return topicPathBuilder.build();
    }

    private static EventsTopicPathBuilder getEventsTopicPathBuilderOrThrow(PolicyEvent<?> event, TopicPath.Channel channel) {
        TopicPathBuilder topicPathBuilder = ProtocolFactory.newTopicPathBuilder(event.getEntityId());
        if (TopicPath.Channel.NONE != channel) {
            throw (UnknownChannelException)UnknownChannelException.newBuilder(channel, event.getType()).dittoHeaders(event.getDittoHeaders()).build();
        }
        topicPathBuilder = topicPathBuilder.none();
        return topicPathBuilder.events();
    }

    private static String getLowerCaseEventName(PolicyEvent<?> thingEvent) {
        Class thingEventClass = thingEvent.getClass();
        String eventClassSimpleName = thingEventClass.getSimpleName();
        return eventClassSimpleName.toLowerCase(Locale.ENGLISH);
    }

    private static boolean isAction(String eventName, TopicPath.Action expectedAction) {
        return eventName.contains(expectedAction.getName());
    }
}

