/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.policies.model.signals.announcements.PolicyAnnouncement;
import org.eclipse.ditto.policies.model.signals.announcements.SubjectDeletionAnnouncement;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.mapper.AbstractSignalMapper;

final class PolicyAnnouncementSignalMapper
extends AbstractSignalMapper<PolicyAnnouncement<?>> {
    PolicyAnnouncementSignalMapper() {
    }

    @Override
    TopicPath getTopicPath(PolicyAnnouncement<?> signal, TopicPath.Channel channel) {
        return ProtocolFactory.newTopicPathBuilder(signal.getEntityId()).policies().announcements().name(signal.getName()).build();
    }

    @Override
    void enhancePayloadBuilder(PolicyAnnouncement<?> signal, PayloadBuilder payloadBuilder) {
        if (signal instanceof SubjectDeletionAnnouncement) {
            SubjectDeletionAnnouncement announcement = (SubjectDeletionAnnouncement)signal;
            JsonObject payload = PolicyAnnouncementSignalMapper.getSubjectDeletionAnnouncementPayload(announcement);
            payloadBuilder.withValue((JsonValue)payload).build();
        }
    }

    private static JsonObject getSubjectDeletionAnnouncementPayload(SubjectDeletionAnnouncement announcement) {
        return JsonObject.newBuilder().set(SubjectDeletionAnnouncement.JsonFields.DELETE_AT, (Object)announcement.getDeleteAt().toString()).set(SubjectDeletionAnnouncement.JsonFields.SUBJECT_IDS, (Object)((JsonArray)announcement.getSubjectIds().stream().map(JsonValue::of).collect(JsonCollectors.valuesToArray()))).build();
    }
}

