/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import java.util.Map;
import java.util.Optional;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.base.model.signals.commands.CommandResponse;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.messages.model.Message;
import org.eclipse.ditto.messages.model.signals.commands.MessageCommand;
import org.eclipse.ditto.messages.model.signals.commands.MessageCommandResponse;
import org.eclipse.ditto.messages.model.signals.commands.WithMessage;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.mapper.AbstractSignalMapper;
import org.eclipse.ditto.things.model.WithThingId;

final class MessageSignalMapper<T extends Signal<?> & WithThingId>
extends AbstractSignalMapper<T> {
    private MessageSignalMapper() {
    }

    static <T extends Signal<?> & WithThingId> MessageSignalMapper<T> getInstance() {
        return new MessageSignalMapper<T>();
    }

    @Override
    void validate(T signal, TopicPath.Channel channel) {
        if (TopicPath.Channel.LIVE != channel) {
            throw new IllegalArgumentException("Unknown Channel '" + (Object)((Object)channel) + "'");
        }
    }

    @Override
    TopicPath getTopicPath(T signal, TopicPath.Channel channel) {
        return ProtocolFactory.newTopicPathBuilder(((WithThingId)signal).getEntityId()).live().messages().subject(((WithMessage)signal).getMessage().getSubject()).build();
    }

    @Override
    void enhancePayloadBuilder(T signal, PayloadBuilder payloadBuilder) {
        JsonPointer payloadPointer;
        JsonObject signalJson = (JsonObject)signal.toJson();
        if (this.isCommandResponse(signal)) {
            payloadPointer = MessageSignalMapper.getPayloadPointer(MessageCommandResponse.JsonFields.JSON_MESSAGE, MessageCommandResponse.JsonFields.JSON_MESSAGE_PAYLOAD);
            MessageSignalMapper.getHttpStatus(signalJson).orElseGet(() -> this.getMessageHttpStatus(signal)).ifPresent(payloadBuilder::withStatus);
        } else {
            payloadPointer = MessageSignalMapper.getPayloadPointer(MessageCommand.JsonFields.JSON_MESSAGE, MessageCommand.JsonFields.JSON_MESSAGE_PAYLOAD);
        }
        signalJson.getValue((CharSequence)payloadPointer).ifPresent(payloadBuilder::withValue);
    }

    private boolean isCommandResponse(T signal) {
        String signalType = signal.getType();
        return signalType.startsWith("messages.responses:");
    }

    private static JsonPointer getPayloadPointer(JsonFieldDefinition<?> messageFieldDefinition, JsonFieldDefinition<?> payloadFieldDefinition) {
        JsonPointer messagePointer = messageFieldDefinition.getPointer();
        return messagePointer.append(payloadFieldDefinition.getPointer());
    }

    private static Optional<Optional<HttpStatus>> getHttpStatus(JsonObject signalJson) {
        return signalJson.getValue(CommandResponse.JsonFields.STATUS).map(HttpStatus::tryGetInstance);
    }

    private Optional<HttpStatus> getMessageHttpStatus(T signal) {
        Message message = ((WithMessage)signal).getMessage();
        return message.getHttpStatus();
    }

    @Override
    DittoHeaders enhanceHeaders(T signal) {
        return DittoHeaders.newBuilder((Map)signal.getDittoHeaders()).putHeaders((Map)((WithMessage)signal).getMessage().getHeaders()).build();
    }
}

