/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import org.eclipse.ditto.connectivity.model.signals.announcements.ConnectionClosedAnnouncement;
import org.eclipse.ditto.connectivity.model.signals.announcements.ConnectionOpenedAnnouncement;
import org.eclipse.ditto.connectivity.model.signals.announcements.ConnectivityAnnouncement;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.mapper.AbstractSignalMapper;

final class ConnectivityAnnouncementSignalMapper
extends AbstractSignalMapper<ConnectivityAnnouncement<?>> {
    ConnectivityAnnouncementSignalMapper() {
    }

    @Override
    TopicPath getTopicPath(ConnectivityAnnouncement<?> signal, TopicPath.Channel channel) {
        return ProtocolFactory.newTopicPathBuilderFromName(signal.getEntityId().toString()).connections().announcements().name(signal.getName()).build();
    }

    @Override
    void enhancePayloadBuilder(ConnectivityAnnouncement<?> signal, PayloadBuilder payloadBuilder) {
        JsonObject payload;
        ConnectionOpenedAnnouncement announcement;
        if (signal instanceof ConnectionOpenedAnnouncement) {
            announcement = (ConnectionOpenedAnnouncement)signal;
            payload = ConnectivityAnnouncementSignalMapper.getConnectionOpenedAnnouncementPayload(announcement);
            payloadBuilder.withValue((JsonValue)payload).build();
        }
        if (signal instanceof ConnectionClosedAnnouncement) {
            announcement = (ConnectionClosedAnnouncement)signal;
            payload = ConnectivityAnnouncementSignalMapper.getConnectionClosedAnnouncementPayload((ConnectionClosedAnnouncement)announcement);
            payloadBuilder.withValue((JsonValue)payload).build();
        }
    }

    private static JsonObject getConnectionOpenedAnnouncementPayload(ConnectionOpenedAnnouncement announcement) {
        return JsonObject.newBuilder().set(ConnectionOpenedAnnouncement.JsonFields.OPENED_AT, (Object)announcement.getOpenedAt().toString()).build();
    }

    private static JsonObject getConnectionClosedAnnouncementPayload(ConnectionClosedAnnouncement announcement) {
        return JsonObject.newBuilder().set(ConnectionClosedAnnouncement.JsonFields.CLOSED_AT, (Object)announcement.getClosedAt().toString()).build();
    }
}

