/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import java.util.Map;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.mapper.SignalMapper;

abstract class AbstractSignalMapper<T extends Signal<?>>
implements SignalMapper<T> {
    AbstractSignalMapper() {
    }

    @Override
    public Adaptable mapSignalToAdaptable(T signal, TopicPath.Channel channel) {
        this.validate(signal, channel);
        PayloadBuilder payloadBuilder = Payload.newBuilder(signal.getResourcePath());
        this.enhancePayloadBuilder(signal, payloadBuilder);
        DittoHeaders dittoHeaders = this.enhanceHeaders(signal);
        return Adaptable.newBuilder(this.getTopicPath(signal, channel)).withPayload(payloadBuilder.build()).withHeaders(dittoHeaders).build();
    }

    @Override
    public TopicPath mapSignalToTopicPath(T signal, TopicPath.Channel channel) {
        return this.getTopicPath((Signal)ConditionChecker.checkNotNull(signal, (String)"signal"), (TopicPath.Channel)((Object)ConditionChecker.checkNotNull((Object)((Object)channel), (String)"channel")));
    }

    abstract TopicPath getTopicPath(T var1, TopicPath.Channel var2);

    void validate(T signal, TopicPath.Channel channel) {
    }

    void enhancePayloadBuilder(T signal, PayloadBuilder payloadBuilder) {
    }

    DittoHeaders enhanceHeaders(T signal) {
        return ProtocolFactory.newHeadersWithJsonContentType((Map<String, String>)signal.getDittoHeaders());
    }
}

