/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import java.util.stream.Stream;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.protocol.CommandsTopicPathBuilder;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownCommandException;
import org.eclipse.ditto.protocol.UnknownCommandResponseException;
import org.eclipse.ditto.protocol.mapper.AbstractSignalMapper;
import org.eclipse.ditto.protocol.mapper.ResponseSignalMapper;

abstract class AbstractCommandSignalMapper<T extends Signal<?>>
extends AbstractSignalMapper<T> {
    AbstractCommandSignalMapper() {
    }

    @Override
    TopicPath getTopicPath(T command, TopicPath.Channel channel) {
        TopicPathBuilder topicPathBuilder = this.getTopicPathBuilder(command);
        CommandsTopicPathBuilder commandsTopicPathBuilder = AbstractCommandSignalMapper.fromTopicPathBuilderWithChannel(topicPathBuilder, channel);
        this.setTopicPathAction(commandsTopicPathBuilder, command, this.getSupportedActions());
        return commandsTopicPathBuilder.build();
    }

    abstract TopicPathBuilder getTopicPathBuilder(T var1);

    abstract TopicPath.Action[] getSupportedActions();

    private void setTopicPathAction(CommandsTopicPathBuilder builder, T signal, TopicPath.Action ... supportedActions) {
        if (supportedActions.length > 0) {
            String commandName = signal.getClass().getSimpleName().toLowerCase();
            this.setAction(builder, Stream.of(supportedActions).filter(action -> commandName.startsWith(action.toString())).findAny().orElseThrow(() -> this.unknownCommandException(commandName)));
        }
    }

    DittoRuntimeException unknownCommandException(String commandName) {
        if (this instanceof ResponseSignalMapper) {
            return UnknownCommandResponseException.newBuilder(commandName).build();
        }
        return UnknownCommandException.newBuilder(commandName).build();
    }

    private void setAction(CommandsTopicPathBuilder builder, TopicPath.Action action) {
        switch (action) {
            case CREATE: {
                builder.create();
                break;
            }
            case RETRIEVE: {
                builder.retrieve();
                break;
            }
            case MODIFY: {
                builder.modify();
                break;
            }
            case MERGE: {
                builder.merge();
                break;
            }
            case DELETE: {
                builder.delete();
                break;
            }
            default: {
                throw this.unknownCommandException(action.getName());
            }
        }
    }

    private static CommandsTopicPathBuilder fromTopicPathBuilderWithChannel(TopicPathBuilder topicPathBuilder, TopicPath.Channel channel) {
        CommandsTopicPathBuilder commandsTopicPathBuilder;
        switch (channel) {
            case TWIN: {
                commandsTopicPathBuilder = topicPathBuilder.twin().commands();
                break;
            }
            case LIVE: {
                commandsTopicPathBuilder = topicPathBuilder.live().commands();
                break;
            }
            case NONE: {
                commandsTopicPathBuilder = topicPathBuilder.none().commands();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Channel '" + (Object)((Object)channel) + "'");
            }
        }
        return commandsTopicPathBuilder;
    }
}

