/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.things.AbstractThingAdapter;
import org.eclipse.ditto.protocol.mapper.SignalMapperFactory;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategiesFactory;
import org.eclipse.ditto.thingsearch.model.signals.commands.ThingSearchCommand;

final class ThingSearchCommandAdapter
extends AbstractThingAdapter<ThingSearchCommand<?>> {
    private ThingSearchCommandAdapter(HeaderTranslator headerTranslator) {
        super(MappingStrategiesFactory.getThingSearchCommandMappingStrategies(), SignalMapperFactory.newThingSearchSignalMapper(), headerTranslator);
    }

    public static ThingSearchCommandAdapter of(HeaderTranslator headerTranslator) {
        return new ThingSearchCommandAdapter(Objects.requireNonNull(headerTranslator));
    }

    @Override
    protected String getType(Adaptable adaptable) {
        return "thing-search.commands:" + adaptable.getTopicPath().getSearchAction().orElse(null);
    }

    @Override
    public Set<TopicPath.Criterion> getCriteria() {
        return EnumSet.of(TopicPath.Criterion.SEARCH);
    }

    @Override
    public Set<TopicPath.Action> getActions() {
        return Collections.emptySet();
    }

    @Override
    public boolean isForResponses() {
        return false;
    }

    @Override
    public Set<TopicPath.SearchAction> getSearchActions() {
        return EnumSet.of(TopicPath.SearchAction.SUBSCRIBE, TopicPath.SearchAction.REQUEST, TopicPath.SearchAction.CANCEL);
    }

    @Override
    public boolean supportsWildcardTopics() {
        return true;
    }
}

