/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.ditto.things.model.signals.commands.ThingResource;

final class ThingResourceNames {
    private static final Map<ThingResource, String> resourceNames = new EnumMap<ThingResource, String>(ThingResource.class);

    private ThingResourceNames() {
    }

    static Map<ThingResource, String> get() {
        return Collections.unmodifiableMap(resourceNames);
    }

    static Map<ThingResource, String> get(ThingResource ... supportedResources) {
        EnumMap<ThingResource, String> filtered = new EnumMap<ThingResource, String>(ThingResource.class);
        for (ThingResource resource : supportedResources) {
            if (!resourceNames.containsKey(resource)) continue;
            filtered.put(resource, resourceNames.get(resource));
        }
        return Collections.unmodifiableMap(filtered);
    }

    static {
        resourceNames.put(ThingResource.THING, "thing");
        resourceNames.put(ThingResource.POLICY_ID, "policyId");
        resourceNames.put(ThingResource.POLICY, "policy");
        resourceNames.put(ThingResource.POLICY_ENTRIES, "policyEntries");
        resourceNames.put(ThingResource.POLICY_ENTRY, "policyEntry");
        resourceNames.put(ThingResource.POLICY_ENTRY_SUBJECTS, "policyEntrySubjects");
        resourceNames.put(ThingResource.POLICY_ENTRY_SUBJECT, "policyEntrySubject");
        resourceNames.put(ThingResource.POLICY_ENTRY_RESOURCES, "policyEntryResources");
        resourceNames.put(ThingResource.POLICY_ENTRY_RESOURCE, "policyEntryResource");
        resourceNames.put(ThingResource.ATTRIBUTES, "attributes");
        resourceNames.put(ThingResource.ATTRIBUTE, "attribute");
        resourceNames.put(ThingResource.FEATURES, "features");
        resourceNames.put(ThingResource.FEATURE, "feature");
        resourceNames.put(ThingResource.DEFINITION, "definition");
        resourceNames.put(ThingResource.FEATURE_DEFINITION, "featureDefinition");
        resourceNames.put(ThingResource.FEATURE_PROPERTIES, "featureProperties");
        resourceNames.put(ThingResource.FEATURE_PROPERTY, "featureProperty");
        resourceNames.put(ThingResource.FEATURE_DESIRED_PROPERTIES, "featureDesiredProperties");
        resourceNames.put(ThingResource.FEATURE_DESIRED_PROPERTY, "featureDesiredProperty");
    }
}

