/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import java.util.Objects;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.QueryCommandAdapter;
import org.eclipse.ditto.protocol.adapter.things.AbstractThingAdapter;
import org.eclipse.ditto.protocol.mapper.SignalMapperFactory;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategiesFactory;
import org.eclipse.ditto.things.model.signals.commands.query.ThingQueryCommand;

final class ThingQueryCommandAdapter
extends AbstractThingAdapter<ThingQueryCommand<?>>
implements QueryCommandAdapter<ThingQueryCommand<?>> {
    private ThingQueryCommandAdapter(HeaderTranslator headerTranslator) {
        super(MappingStrategiesFactory.getThingQueryCommandMappingStrategies(), SignalMapperFactory.newThingQuerySignalMapper(), headerTranslator);
    }

    public static ThingQueryCommandAdapter of(HeaderTranslator headerTranslator) {
        return new ThingQueryCommandAdapter(Objects.requireNonNull(headerTranslator));
    }

    @Override
    protected String getType(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        if (topicPath.isWildcardTopic()) {
            return "things.commands:retrieveThings";
        }
        return super.getType(adaptable);
    }
}

