/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import java.util.Map;
import java.util.Optional;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.protocol.PayloadPathMatcher;
import org.eclipse.ditto.protocol.UnknownPathException;
import org.eclipse.ditto.protocol.adapter.things.ThingResourceNames;
import org.eclipse.ditto.things.model.signals.commands.ThingResource;

final class ThingModifyPathMatcher
implements PayloadPathMatcher {
    private static final Map<ThingResource, String> RESOURCE_NAMES = ThingResourceNames.get();
    private static final ThingModifyPathMatcher INSTANCE = new ThingModifyPathMatcher();

    private ThingModifyPathMatcher() {
    }

    static ThingModifyPathMatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public String match(JsonPointer path) {
        ThingResource resource = (ThingResource)ThingResource.from((JsonPointer)path).orElseThrow(() -> (UnknownPathException)UnknownPathException.newBuilder(path).build());
        return Optional.ofNullable(RESOURCE_NAMES.get(resource)).orElseThrow(() -> (UnknownPathException)UnknownPathException.newBuilder(path).build());
    }
}

