/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import java.util.Map;
import java.util.Optional;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.protocol.PayloadPathMatcher;
import org.eclipse.ditto.protocol.UnknownPathException;
import org.eclipse.ditto.protocol.adapter.things.ThingResourceNames;
import org.eclipse.ditto.things.model.signals.commands.ThingResource;

final class ThingMergePathMatcher
implements PayloadPathMatcher {
    private static final Map<ThingResource, String> MERGE_RESOURCE_NAMES = ThingResourceNames.get(ThingResource.THING, ThingResource.POLICY_ID, ThingResource.DEFINITION, ThingResource.ATTRIBUTES, ThingResource.ATTRIBUTE, ThingResource.FEATURES, ThingResource.FEATURE, ThingResource.FEATURE_DEFINITION, ThingResource.FEATURE_PROPERTIES, ThingResource.FEATURE_PROPERTY, ThingResource.FEATURE_DESIRED_PROPERTIES, ThingResource.FEATURE_DESIRED_PROPERTY);
    private static final ThingMergePathMatcher INSTANCE = new ThingMergePathMatcher();

    private ThingMergePathMatcher() {
    }

    static ThingMergePathMatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public String match(JsonPointer path) {
        ThingResource resource = (ThingResource)ThingResource.from((JsonPointer)path).orElseThrow(() -> (UnknownPathException)UnknownPathException.newBuilder(path).build());
        return Optional.ofNullable(MERGE_RESOURCE_NAMES.get(resource)).orElseThrow(() -> (UnknownPathException)UnknownPathException.newBuilder(path).build());
    }
}

