/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import java.util.Objects;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.AbstractAdapter;
import org.eclipse.ditto.protocol.adapter.EventAdapter;
import org.eclipse.ditto.protocol.adapter.things.AbstractThingAdapter;
import org.eclipse.ditto.protocol.mapper.SignalMapperFactory;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategiesFactory;
import org.eclipse.ditto.things.model.signals.events.ThingEvent;

final class ThingEventAdapter
extends AbstractThingAdapter<ThingEvent<?>>
implements EventAdapter<ThingEvent<?>> {
    private ThingEventAdapter(HeaderTranslator headerTranslator) {
        super(MappingStrategiesFactory.getThingEventMappingStrategies(), SignalMapperFactory.newThingEventSignalMapper(), headerTranslator);
    }

    public static ThingEventAdapter of(HeaderTranslator headerTranslator) {
        return new ThingEventAdapter(Objects.requireNonNull(headerTranslator));
    }

    private static String getActionNameWithFirstLetterUpperCase(TopicPath topicPath) {
        return topicPath.getAction().map(TopicPath.Action::toString).map(x$0 -> AbstractAdapter.upperCaseFirst(x$0)).orElseThrow(() -> new NullPointerException("TopicPath did not contain an Action!"));
    }

    @Override
    protected String getType(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        MessagePath path = adaptable.getPayload().getPath();
        String eventName = this.payloadPathMatcher.match(path) + ThingEventAdapter.getActionNameWithFirstLetterUpperCase(topicPath);
        return (Object)((Object)topicPath.getGroup()) + "." + (Object)((Object)topicPath.getCriterion()) + ":" + eventName;
    }
}

