/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import java.util.Objects;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.AbstractErrorResponseAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingAdapter;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.signals.commands.ThingErrorResponse;

final class ThingErrorResponseAdapter
extends AbstractErrorResponseAdapter<ThingErrorResponse>
implements ThingAdapter<ThingErrorResponse> {
    private ThingErrorResponseAdapter(HeaderTranslator headerTranslator, ErrorRegistry<DittoRuntimeException> errorRegistry) {
        super(headerTranslator, errorRegistry);
    }

    public static ThingErrorResponseAdapter of(HeaderTranslator headerTranslator, ErrorRegistry<DittoRuntimeException> errorRegistry) {
        return new ThingErrorResponseAdapter(Objects.requireNonNull(headerTranslator), errorRegistry);
    }

    @Override
    public TopicPath getTopicPath(ThingErrorResponse errorResponse, TopicPath.Channel channel) {
        return ThingErrorResponseAdapter.addChannelToTopicPathBuilder(ProtocolFactory.newTopicPathBuilder(errorResponse.getEntityId()), channel).build();
    }

    @Override
    public ThingErrorResponse buildErrorResponse(TopicPath topicPath, DittoRuntimeException exception, DittoHeaders dittoHeaders) {
        return ThingErrorResponse.of((ThingId)ThingId.of((String)topicPath.getNamespace(), (String)topicPath.getEntityName()), (DittoRuntimeException)exception, (DittoHeaders)dittoHeaders);
    }
}

