/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.things.AbstractThingAdapter;
import org.eclipse.ditto.protocol.mapper.SignalMapperFactory;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategiesFactory;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionEvent;

final class SubscriptionEventAdapter
extends AbstractThingAdapter<SubscriptionEvent<?>> {
    private SubscriptionEventAdapter(HeaderTranslator headerTranslator, ErrorRegistry<?> errorRegistry) {
        super(MappingStrategiesFactory.getSubscriptionEventMappingStrategies(errorRegistry), SignalMapperFactory.newSubscriptionEventSignalMapper(), headerTranslator);
    }

    public static SubscriptionEventAdapter of(HeaderTranslator headerTranslator, ErrorRegistry<?> errorRegistry) {
        return new SubscriptionEventAdapter((HeaderTranslator)ConditionChecker.checkNotNull((Object)headerTranslator, (String)"headerTranslator"), (ErrorRegistry)ConditionChecker.checkNotNull(errorRegistry, (String)"errorRegistry"));
    }

    @Override
    protected String getType(Adaptable adaptable) {
        return "thing-search.subscription.events:" + adaptable.getTopicPath().getSearchAction().orElse(null);
    }

    @Override
    public Set<TopicPath.Criterion> getCriteria() {
        return EnumSet.of(TopicPath.Criterion.SEARCH);
    }

    @Override
    public Set<TopicPath.Action> getActions() {
        return Collections.emptySet();
    }

    @Override
    public boolean isForResponses() {
        return false;
    }

    @Override
    public Set<TopicPath.SearchAction> getSearchActions() {
        return EnumSet.of(TopicPath.SearchAction.COMPLETE, TopicPath.SearchAction.NEXT, TopicPath.SearchAction.FAILED, TopicPath.SearchAction.GENERATED);
    }
}

