/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.AbstractErrorResponseAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingAdapter;
import org.eclipse.ditto.thingsearch.model.signals.commands.SearchErrorResponse;

final class SearchErrorResponseAdapter
extends AbstractErrorResponseAdapter<SearchErrorResponse>
implements ThingAdapter<SearchErrorResponse> {
    private SearchErrorResponseAdapter(HeaderTranslator headerTranslator, ErrorRegistry<DittoRuntimeException> errorRegistry) {
        super(headerTranslator, errorRegistry);
    }

    public static SearchErrorResponseAdapter of(HeaderTranslator headerTranslator, ErrorRegistry<DittoRuntimeException> errorRegistry) {
        return new SearchErrorResponseAdapter(Objects.requireNonNull(headerTranslator), errorRegistry);
    }

    @Override
    public TopicPath getTopicPath(SearchErrorResponse errorResponse, TopicPath.Channel channel) {
        return ProtocolFactory.newTopicPathBuilderFromNamespace("_").things().none().search().error().build();
    }

    @Override
    public boolean supportsWildcardTopics() {
        return true;
    }

    @Override
    public Set<TopicPath.SearchAction> getSearchActions() {
        return EnumSet.of(TopicPath.SearchAction.ERROR);
    }

    @Override
    public SearchErrorResponse buildErrorResponse(TopicPath topicPath, DittoRuntimeException exception, DittoHeaders dittoHeaders) {
        return SearchErrorResponse.of((DittoRuntimeException)exception, (DittoHeaders)dittoHeaders);
    }
}

