/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import java.util.Objects;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.messages.model.signals.commands.MessageCommand;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.adapter.EmptyPathMatcher;
import org.eclipse.ditto.protocol.adapter.things.AbstractMessageAdapter;
import org.eclipse.ditto.protocol.mapper.SignalMapperFactory;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategiesFactory;

final class MessageCommandAdapter
extends AbstractMessageAdapter<MessageCommand<?, ?>> {
    private MessageCommandAdapter(HeaderTranslator headerTranslator) {
        super(MappingStrategiesFactory.getMessageCommandMappingStrategies(), SignalMapperFactory.newMessageCommandSignalMapper(), headerTranslator, EmptyPathMatcher.getInstance());
    }

    public static MessageCommandAdapter of(HeaderTranslator headerTranslator) {
        return new MessageCommandAdapter(Objects.requireNonNull(headerTranslator));
    }

    @Override
    public boolean isForResponses() {
        return false;
    }

    @Override
    public boolean requiresSubject() {
        return true;
    }

    @Override
    protected String getType(Adaptable adaptable) {
        if (adaptable.getTopicPath().getSubject().filter("claim"::equals).isPresent()) {
            return "messages.commands:claimMessage";
        }
        if (adaptable.getPayload().getPath().getFeatureId().isPresent()) {
            return "messages.commands:featureMessage";
        }
        return "messages.commands:thingMessage";
    }
}

