/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import java.util.Arrays;
import java.util.List;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.messages.model.signals.commands.MessageCommand;
import org.eclipse.ditto.messages.model.signals.commands.MessageCommandResponse;
import org.eclipse.ditto.protocol.adapter.Adapter;
import org.eclipse.ditto.protocol.adapter.provider.ThingCommandAdapterProvider;
import org.eclipse.ditto.protocol.adapter.things.MessageCommandAdapter;
import org.eclipse.ditto.protocol.adapter.things.MessageCommandResponseAdapter;
import org.eclipse.ditto.protocol.adapter.things.RetrieveThingsCommandAdapter;
import org.eclipse.ditto.protocol.adapter.things.RetrieveThingsCommandResponseAdapter;
import org.eclipse.ditto.protocol.adapter.things.SearchErrorResponseAdapter;
import org.eclipse.ditto.protocol.adapter.things.SubscriptionEventAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingErrorResponseAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingEventAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingMergeCommandAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingMergeCommandResponseAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingMergedEventAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingModifyCommandAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingModifyCommandResponseAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingQueryCommandAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingQueryCommandResponseAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingSearchCommandAdapter;
import org.eclipse.ditto.things.model.signals.commands.ThingErrorResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.MergeThing;
import org.eclipse.ditto.things.model.signals.commands.modify.MergeThingResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ThingModifyCommand;
import org.eclipse.ditto.things.model.signals.commands.modify.ThingModifyCommandResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveThings;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveThingsResponse;
import org.eclipse.ditto.things.model.signals.commands.query.ThingQueryCommand;
import org.eclipse.ditto.things.model.signals.commands.query.ThingQueryCommandResponse;
import org.eclipse.ditto.things.model.signals.events.ThingEvent;
import org.eclipse.ditto.things.model.signals.events.ThingMerged;
import org.eclipse.ditto.thingsearch.model.signals.commands.SearchErrorResponse;
import org.eclipse.ditto.thingsearch.model.signals.commands.ThingSearchCommand;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionEvent;

public class DefaultThingCommandAdapterProvider
implements ThingCommandAdapterProvider {
    private final ThingQueryCommandAdapter queryCommandAdapter;
    private final ThingModifyCommandAdapter modifyCommandAdapter;
    private final ThingMergeCommandAdapter mergeCommandAdapter;
    private final ThingQueryCommandResponseAdapter queryCommandResponseAdapter;
    private final ThingModifyCommandResponseAdapter modifyCommandResponseAdapter;
    private final ThingMergeCommandResponseAdapter mergeCommandResponseAdapter;
    private final ThingSearchCommandAdapter searchCommandAdapter;
    private final MessageCommandAdapter messageCommandAdapter;
    private final MessageCommandResponseAdapter messageCommandResponseAdapter;
    private final ThingEventAdapter thingEventAdapter;
    private final ThingMergedEventAdapter thingMergedEventAdapter;
    private final SubscriptionEventAdapter subscriptionEventAdapter;
    private final ThingErrorResponseAdapter errorResponseAdapter;
    private final RetrieveThingsCommandAdapter retrieveThingsCommandAdapter;
    private final RetrieveThingsCommandResponseAdapter retrieveThingsCommandResponseAdapter;
    private final SearchErrorResponseAdapter searchErrorResponseAdapter;

    public DefaultThingCommandAdapterProvider(ErrorRegistry<DittoRuntimeException> errorRegistry, HeaderTranslator headerTranslator) {
        this.queryCommandAdapter = ThingQueryCommandAdapter.of(headerTranslator);
        this.retrieveThingsCommandAdapter = RetrieveThingsCommandAdapter.of(headerTranslator);
        this.retrieveThingsCommandResponseAdapter = RetrieveThingsCommandResponseAdapter.of(headerTranslator);
        this.modifyCommandAdapter = ThingModifyCommandAdapter.of(headerTranslator);
        this.mergeCommandAdapter = ThingMergeCommandAdapter.of(headerTranslator);
        this.queryCommandResponseAdapter = ThingQueryCommandResponseAdapter.of(headerTranslator);
        this.modifyCommandResponseAdapter = ThingModifyCommandResponseAdapter.of(headerTranslator);
        this.mergeCommandResponseAdapter = ThingMergeCommandResponseAdapter.of(headerTranslator);
        this.searchCommandAdapter = ThingSearchCommandAdapter.of(headerTranslator);
        this.messageCommandAdapter = MessageCommandAdapter.of(headerTranslator);
        this.messageCommandResponseAdapter = MessageCommandResponseAdapter.of(headerTranslator);
        this.thingEventAdapter = ThingEventAdapter.of(headerTranslator);
        this.thingMergedEventAdapter = ThingMergedEventAdapter.of(headerTranslator);
        this.subscriptionEventAdapter = SubscriptionEventAdapter.of(headerTranslator, errorRegistry);
        this.errorResponseAdapter = ThingErrorResponseAdapter.of(headerTranslator, errorRegistry);
        this.searchErrorResponseAdapter = SearchErrorResponseAdapter.of(headerTranslator, errorRegistry);
    }

    @Override
    public List<Adapter<?>> getAdapters() {
        return Arrays.asList(this.queryCommandAdapter, this.retrieveThingsCommandAdapter, this.retrieveThingsCommandResponseAdapter, this.modifyCommandAdapter, this.mergeCommandAdapter, this.queryCommandResponseAdapter, this.modifyCommandResponseAdapter, this.mergeCommandResponseAdapter, this.messageCommandAdapter, this.messageCommandResponseAdapter, this.thingEventAdapter, this.thingMergedEventAdapter, this.searchCommandAdapter, this.subscriptionEventAdapter, this.errorResponseAdapter, this.searchErrorResponseAdapter);
    }

    @Override
    public Adapter<ThingErrorResponse> getErrorResponseAdapter() {
        return this.errorResponseAdapter;
    }

    @Override
    public Adapter<ThingEvent<?>> getEventAdapter() {
        return this.thingEventAdapter;
    }

    @Override
    public Adapter<ThingMerged> getMergedEventAdapter() {
        return this.thingMergedEventAdapter;
    }

    @Override
    public Adapter<SubscriptionEvent<?>> getSubscriptionEventAdapter() {
        return this.subscriptionEventAdapter;
    }

    @Override
    public Adapter<ThingModifyCommand<?>> getModifyCommandAdapter() {
        return this.modifyCommandAdapter;
    }

    @Override
    public Adapter<MergeThing> getMergeCommandAdapter() {
        return this.mergeCommandAdapter;
    }

    @Override
    public Adapter<ThingModifyCommandResponse<?>> getModifyCommandResponseAdapter() {
        return this.modifyCommandResponseAdapter;
    }

    @Override
    public Adapter<MergeThingResponse> getMergeCommandResponseAdapter() {
        return this.mergeCommandResponseAdapter;
    }

    @Override
    public Adapter<ThingQueryCommand<?>> getQueryCommandAdapter() {
        return this.queryCommandAdapter;
    }

    @Override
    public Adapter<ThingQueryCommandResponse<?>> getQueryCommandResponseAdapter() {
        return this.queryCommandResponseAdapter;
    }

    @Override
    public Adapter<MessageCommand<?, ?>> getMessageCommandAdapter() {
        return this.messageCommandAdapter;
    }

    @Override
    public Adapter<MessageCommandResponse<?, ?>> getMessageCommandResponseAdapter() {
        return this.messageCommandResponseAdapter;
    }

    @Override
    public Adapter<ThingSearchCommand<?>> getSearchCommandAdapter() {
        return this.searchCommandAdapter;
    }

    @Override
    public Adapter<RetrieveThings> getRetrieveThingsCommandAdapter() {
        return this.retrieveThingsCommandAdapter;
    }

    @Override
    public Adapter<RetrieveThingsResponse> getRetrieveThingsCommandResponseAdapter() {
        return this.retrieveThingsCommandResponseAdapter;
    }

    @Override
    public Adapter<SearchErrorResponse> getSearchErrorResponseAdapter() {
        return this.searchErrorResponseAdapter;
    }
}

