/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.things;

import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.PayloadPathMatcher;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.AbstractAdapter;
import org.eclipse.ditto.protocol.adapter.things.ThingMessageAdapter;
import org.eclipse.ditto.protocol.mapper.SignalMapper;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategies;

abstract class AbstractMessageAdapter<T extends Signal<?>>
extends AbstractAdapter<T>
implements ThingMessageAdapter<T> {
    private final SignalMapper<T> signalMapper;

    AbstractMessageAdapter(MappingStrategies<T> mappingStrategies, SignalMapper<T> signalMapper, HeaderTranslator headerTranslator, PayloadPathMatcher payloadPathMatcher) {
        super(mappingStrategies, headerTranslator, payloadPathMatcher);
        this.signalMapper = signalMapper;
    }

    @Override
    protected Adaptable mapSignalToAdaptable(T signal, TopicPath.Channel channel) {
        return this.signalMapper.mapSignalToAdaptable(signal, channel);
    }

    @Override
    public Adaptable toAdaptable(T t) {
        return this.toAdaptable(t, TopicPath.Channel.LIVE);
    }

    @Override
    public TopicPath toTopicPath(T signal, TopicPath.Channel channel) {
        return this.signalMapper.mapSignalToTopicPath(signal, channel);
    }

    @Override
    public Adaptable validateAndPreprocess(Adaptable adaptable) {
        MessagePath messagePath = adaptable.getPayload().getPath();
        if (messagePath.getFeatureId().isPresent()) {
            int featurePathPrefixLevel = 4;
            return this.validateAndPreprocessMessagePathPrefix(adaptable, 4);
        }
        return adaptable;
    }
}

