/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.policies;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.policies.model.signals.commands.PolicyResource;
import org.eclipse.ditto.protocol.PayloadPathMatcher;
import org.eclipse.ditto.protocol.UnknownPathException;

final class PolicyPathMatcher
implements PayloadPathMatcher {
    private static final Map<PolicyResource, String> resourceNames = new EnumMap<PolicyResource, String>(PolicyResource.class);
    private static final PolicyPathMatcher INSTANCE;

    private PolicyPathMatcher() {
    }

    static PolicyPathMatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public String match(JsonPointer path) {
        PolicyResource resource = (PolicyResource)PolicyResource.from((JsonPointer)path).orElseThrow(() -> (UnknownPathException)UnknownPathException.newBuilder(path).build());
        return Optional.ofNullable(resourceNames.get(resource)).orElseThrow(() -> (UnknownPathException)UnknownPathException.newBuilder(path).build());
    }

    static {
        resourceNames.put(PolicyResource.POLICY, "policy");
        resourceNames.put(PolicyResource.POLICY_IMPORTS, "policyImports");
        resourceNames.put(PolicyResource.POLICY_IMPORT, "policyImport");
        resourceNames.put(PolicyResource.POLICY_ENTRIES, "policyEntries");
        resourceNames.put(PolicyResource.POLICY_ENTRY, "policyEntry");
        resourceNames.put(PolicyResource.POLICY_ENTRY_RESOURCES, "resources");
        resourceNames.put(PolicyResource.POLICY_ENTRY_RESOURCE, "resource");
        resourceNames.put(PolicyResource.POLICY_ENTRY_SUBJECTS, "subjects");
        resourceNames.put(PolicyResource.POLICY_ENTRY_SUBJECT, "subject");
        INSTANCE = new PolicyPathMatcher();
    }
}

