/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.policies;

import java.util.Objects;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.policies.model.signals.events.PolicyEvent;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.AbstractAdapter;
import org.eclipse.ditto.protocol.adapter.EventAdapter;
import org.eclipse.ditto.protocol.adapter.policies.AbstractPolicyAdapter;
import org.eclipse.ditto.protocol.mapper.SignalMapperFactory;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategiesFactory;

final class PolicyEventAdapter
extends AbstractPolicyAdapter<PolicyEvent<?>>
implements EventAdapter<PolicyEvent<?>> {
    private PolicyEventAdapter(HeaderTranslator headerTranslator) {
        super(MappingStrategiesFactory.getPolicyEventMappingStrategies(), SignalMapperFactory.newPolicyEventSignalMapper(), headerTranslator);
    }

    public static PolicyEventAdapter of(HeaderTranslator headerTranslator) {
        return new PolicyEventAdapter(Objects.requireNonNull(headerTranslator));
    }

    private static String getActionNameWithFirstLetterUpperCase(TopicPath topicPath) {
        return topicPath.getAction().map(TopicPath.Action::toString).map(x$0 -> AbstractAdapter.upperCaseFirst(x$0)).orElseThrow(() -> new NullPointerException("TopicPath did not contain an Action!"));
    }

    @Override
    protected String getType(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        MessagePath path = adaptable.getPayload().getPath();
        String eventName = this.payloadPathMatcher.match(path) + PolicyEventAdapter.getActionNameWithFirstLetterUpperCase(topicPath);
        return (Object)((Object)topicPath.getGroup()) + "." + (Object)((Object)topicPath.getCriterion()) + ":" + eventName;
    }
}

