/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.policies;

import java.util.Objects;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.policies.model.signals.commands.PolicyErrorResponse;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.AbstractErrorResponseAdapter;
import org.eclipse.ditto.protocol.adapter.policies.PolicyAdapter;

final class PolicyErrorResponseAdapter
extends AbstractErrorResponseAdapter<PolicyErrorResponse>
implements PolicyAdapter<PolicyErrorResponse> {
    private PolicyErrorResponseAdapter(HeaderTranslator headerTranslator, ErrorRegistry<DittoRuntimeException> errorRegistry) {
        super(headerTranslator, errorRegistry);
    }

    public static PolicyErrorResponseAdapter of(HeaderTranslator headerTranslator, ErrorRegistry<DittoRuntimeException> errorRegistry) {
        return new PolicyErrorResponseAdapter(Objects.requireNonNull(headerTranslator), errorRegistry);
    }

    @Override
    public TopicPath getTopicPath(PolicyErrorResponse errorResponse, TopicPath.Channel channel) {
        return PolicyErrorResponseAdapter.addChannelToTopicPathBuilder(ProtocolFactory.newTopicPathBuilder(errorResponse.getEntityId()), channel).build();
    }

    @Override
    public PolicyErrorResponse buildErrorResponse(TopicPath topicPath, DittoRuntimeException exception, DittoHeaders dittoHeaders) {
        return PolicyErrorResponse.of((PolicyId)PolicyId.of((String)topicPath.getNamespace(), (String)topicPath.getEntityName()), (DittoRuntimeException)exception, (DittoHeaders)dittoHeaders);
    }
}

