/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.policies;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.policies.model.signals.announcements.PolicyAnnouncement;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.UnknownTopicPathException;
import org.eclipse.ditto.protocol.adapter.policies.AbstractPolicyAdapter;
import org.eclipse.ditto.protocol.mapper.SignalMapperFactory;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategiesFactory;

final class PolicyAnnouncementAdapter
extends AbstractPolicyAdapter<PolicyAnnouncement<?>> {
    private PolicyAnnouncementAdapter(HeaderTranslator headerTranslator) {
        super(MappingStrategiesFactory.getPolicyAnnouncementMappingStrategies(), SignalMapperFactory.newPolicyAnnouncementSignalMapper(), headerTranslator);
    }

    public static PolicyAnnouncementAdapter of(HeaderTranslator headerTranslator) {
        return new PolicyAnnouncementAdapter(Objects.requireNonNull(headerTranslator));
    }

    @Override
    public Set<TopicPath.Criterion> getCriteria() {
        return Collections.singleton(TopicPath.Criterion.ANNOUNCEMENTS);
    }

    @Override
    public Set<TopicPath.Action> getActions() {
        return Collections.emptySet();
    }

    @Override
    public boolean isForResponses() {
        return false;
    }

    @Override
    protected String getType(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        String commandName = topicPath.getSubject().orElseThrow(() -> (UnknownTopicPathException)UnknownTopicPathException.newBuilder(topicPath).build());
        return (Object)((Object)topicPath.getGroup()) + "." + this.getTypeCriterionAsString(topicPath) + ":" + commandName;
    }
}

