/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.policies;

import java.util.Arrays;
import java.util.List;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.policies.model.signals.announcements.PolicyAnnouncement;
import org.eclipse.ditto.policies.model.signals.commands.PolicyErrorResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.PolicyModifyCommand;
import org.eclipse.ditto.policies.model.signals.commands.modify.PolicyModifyCommandResponse;
import org.eclipse.ditto.policies.model.signals.commands.query.PolicyQueryCommand;
import org.eclipse.ditto.policies.model.signals.commands.query.PolicyQueryCommandResponse;
import org.eclipse.ditto.policies.model.signals.events.PolicyEvent;
import org.eclipse.ditto.protocol.adapter.Adapter;
import org.eclipse.ditto.protocol.adapter.policies.PolicyAnnouncementAdapter;
import org.eclipse.ditto.protocol.adapter.policies.PolicyErrorResponseAdapter;
import org.eclipse.ditto.protocol.adapter.policies.PolicyEventAdapter;
import org.eclipse.ditto.protocol.adapter.policies.PolicyModifyCommandAdapter;
import org.eclipse.ditto.protocol.adapter.policies.PolicyModifyCommandResponseAdapter;
import org.eclipse.ditto.protocol.adapter.policies.PolicyQueryCommandAdapter;
import org.eclipse.ditto.protocol.adapter.policies.PolicyQueryCommandResponseAdapter;
import org.eclipse.ditto.protocol.adapter.provider.PolicyCommandAdapterProvider;

public final class DefaultPolicyCommandAdapterProvider
implements PolicyCommandAdapterProvider {
    private final PolicyErrorResponseAdapter policyErrorResponseAdapter;
    private final PolicyModifyCommandAdapter policyModifyCommandAdapter;
    private final PolicyQueryCommandAdapter policyQueryCommandAdapter;
    private final PolicyModifyCommandResponseAdapter policyModifyCommandResponseAdapter;
    private final PolicyQueryCommandResponseAdapter policyQueryCommandResponseAdapter;
    private final PolicyAnnouncementAdapter policyAnnouncementAdapter;
    private final PolicyEventAdapter policyEventAdapter;

    public DefaultPolicyCommandAdapterProvider(ErrorRegistry<DittoRuntimeException> errorRegistry, HeaderTranslator headerTranslator) {
        this.policyErrorResponseAdapter = PolicyErrorResponseAdapter.of(headerTranslator, errorRegistry);
        this.policyModifyCommandAdapter = PolicyModifyCommandAdapter.of(headerTranslator);
        this.policyQueryCommandAdapter = PolicyQueryCommandAdapter.of(headerTranslator);
        this.policyModifyCommandResponseAdapter = PolicyModifyCommandResponseAdapter.of(headerTranslator);
        this.policyQueryCommandResponseAdapter = PolicyQueryCommandResponseAdapter.of(headerTranslator);
        this.policyAnnouncementAdapter = PolicyAnnouncementAdapter.of(headerTranslator);
        this.policyEventAdapter = PolicyEventAdapter.of(headerTranslator);
    }

    @Override
    public Adapter<PolicyErrorResponse> getErrorResponseAdapter() {
        return this.policyErrorResponseAdapter;
    }

    @Override
    public Adapter<PolicyModifyCommand<?>> getModifyCommandAdapter() {
        return this.policyModifyCommandAdapter;
    }

    @Override
    public Adapter<PolicyModifyCommandResponse<?>> getModifyCommandResponseAdapter() {
        return this.policyModifyCommandResponseAdapter;
    }

    @Override
    public Adapter<PolicyQueryCommand<?>> getQueryCommandAdapter() {
        return this.policyQueryCommandAdapter;
    }

    @Override
    public Adapter<PolicyQueryCommandResponse<?>> getQueryCommandResponseAdapter() {
        return this.policyQueryCommandResponseAdapter;
    }

    @Override
    public Adapter<PolicyAnnouncement<?>> getAnnouncementAdapter() {
        return this.policyAnnouncementAdapter;
    }

    @Override
    public Adapter<PolicyEvent<?>> getEventAdapter() {
        return this.policyEventAdapter;
    }

    @Override
    public List<Adapter<?>> getAdapters() {
        return Arrays.asList(this.policyErrorResponseAdapter, this.policyModifyCommandAdapter, this.policyQueryCommandAdapter, this.policyModifyCommandResponseAdapter, this.policyQueryCommandResponseAdapter, this.policyAnnouncementAdapter, this.policyEventAdapter);
    }
}

