/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.policies;

import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.AbstractAdapter;
import org.eclipse.ditto.protocol.adapter.policies.PolicyAdapter;
import org.eclipse.ditto.protocol.adapter.policies.PolicyPathMatcher;
import org.eclipse.ditto.protocol.mapper.SignalMapper;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategies;

abstract class AbstractPolicyAdapter<T extends Signal<?>>
extends AbstractAdapter<T>
implements PolicyAdapter<T> {
    private final SignalMapper<T> signalMapper;

    protected AbstractPolicyAdapter(MappingStrategies<T> mappingStrategies, SignalMapper<T> signalMapper, HeaderTranslator headerTranslator) {
        super(mappingStrategies, headerTranslator, PolicyPathMatcher.getInstance());
        this.signalMapper = signalMapper;
    }

    @Override
    protected Adaptable mapSignalToAdaptable(T signal, TopicPath.Channel channel) {
        return this.signalMapper.mapSignalToAdaptable(signal, channel);
    }

    @Override
    public TopicPath toTopicPath(T signal, TopicPath.Channel channel) {
        return this.signalMapper.mapSignalToTopicPath(signal, channel);
    }

    @Override
    public Adaptable validateAndPreprocess(Adaptable adaptable) {
        String subjectsPathSegment = "subjects";
        int subjectsPathLevel = 2;
        MessagePath messagePath = adaptable.getPayload().getPath();
        boolean isSubjectSignal = messagePath.get(2).map(CharSequence::toString).filter("subjects"::equals).isPresent();
        if (isSubjectSignal) {
            return this.validateAndPreprocessMessagePathPrefix(adaptable, 3);
        }
        return super.validateAndPreprocess(adaptable);
    }
}

