/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.connectivity;

import java.util.Collections;
import java.util.Set;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.connectivity.model.signals.announcements.ConnectivityAnnouncement;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.UnknownTopicPathException;
import org.eclipse.ditto.protocol.adapter.connectivity.AbstractConnectivityAdapter;
import org.eclipse.ditto.protocol.mapper.SignalMapperFactory;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategiesFactory;

final class ConnectivityAnnouncementAdapter
extends AbstractConnectivityAdapter<ConnectivityAnnouncement<?>> {
    private ConnectivityAnnouncementAdapter(HeaderTranslator headerTranslator) {
        super(MappingStrategiesFactory.getConnectivityAnnouncementMappingStrategies(), SignalMapperFactory.newConnectivityAnnouncementSignalMapper(), headerTranslator);
    }

    public static ConnectivityAnnouncementAdapter of(HeaderTranslator headerTranslator) {
        return new ConnectivityAnnouncementAdapter((HeaderTranslator)ConditionChecker.checkNotNull((Object)headerTranslator, (String)"headerTranslator"));
    }

    @Override
    public Set<TopicPath.Criterion> getCriteria() {
        return Collections.singleton(TopicPath.Criterion.ANNOUNCEMENTS);
    }

    @Override
    public Set<TopicPath.Action> getActions() {
        return Collections.emptySet();
    }

    @Override
    public boolean isForResponses() {
        return false;
    }

    @Override
    protected String getType(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        String commandName = topicPath.getSubject().orElseThrow(() -> (UnknownTopicPathException)UnknownTopicPathException.newBuilder(topicPath).build());
        return this.getCommandTypePrefix(topicPath) + "." + this.getTypeCriterionAsString(topicPath) + ":" + commandName;
    }

    private String getCommandTypePrefix(TopicPath topicPath) {
        return topicPath.getGroup().toString().replace(TopicPath.Group.CONNECTIONS.getName(), "connectivity");
    }
}

