/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.acknowledgements;

import java.util.Arrays;
import java.util.List;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.base.model.signals.acks.Acknowledgement;
import org.eclipse.ditto.base.model.signals.acks.Acknowledgements;
import org.eclipse.ditto.protocol.adapter.Adapter;
import org.eclipse.ditto.protocol.adapter.acknowledgements.AcknowledgementAdapter;
import org.eclipse.ditto.protocol.adapter.acknowledgements.AcknowledgementsAdapter;
import org.eclipse.ditto.protocol.adapter.provider.AcknowledgementAdapterProvider;

public final class DefaultAcknowledgementsAdapterProvider
implements AcknowledgementAdapterProvider {
    private final AcknowledgementAdapter acknowledgementAdapter;
    private final AcknowledgementsAdapter acknowledgementsAdapter;

    public DefaultAcknowledgementsAdapterProvider(ErrorRegistry<DittoRuntimeException> errorRegistry, HeaderTranslator headerTranslator) {
        this.acknowledgementAdapter = AcknowledgementAdapter.getInstance(headerTranslator);
        this.acknowledgementsAdapter = AcknowledgementsAdapter.getInstance(headerTranslator);
    }

    @Override
    public List<Adapter<?>> getAdapters() {
        return Arrays.asList(this.acknowledgementAdapter, this.acknowledgementsAdapter);
    }

    @Override
    public Adapter<Acknowledgement> getAcknowledgementAdapter() {
        return this.acknowledgementAdapter;
    }

    @Override
    public Adapter<Acknowledgements> getAcknowledgementsAdapter() {
        return this.acknowledgementsAdapter;
    }
}

