/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.acknowledgements;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.acks.Acknowledgement;
import org.eclipse.ditto.base.model.signals.acks.Acknowledgements;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.Adapter;
import org.eclipse.ditto.protocol.adapter.acknowledgements.AcknowledgementAdapter;
import org.eclipse.ditto.things.model.ThingConstants;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.signals.acks.ThingAcknowledgementsFactory;

final class AcknowledgementsAdapter
implements Adapter<Acknowledgements> {
    private final HeaderTranslator headerTranslator;

    private AcknowledgementsAdapter(HeaderTranslator headerTranslator) {
        this.headerTranslator = headerTranslator;
    }

    static AcknowledgementsAdapter getInstance(HeaderTranslator headerTranslator) {
        return new AcknowledgementsAdapter((HeaderTranslator)ConditionChecker.checkNotNull((Object)headerTranslator, (String)"headerTranslator"));
    }

    @Override
    public Acknowledgements fromAdaptable(Adaptable adaptable) {
        ConditionChecker.checkNotNull((Object)adaptable, (String)"adaptable");
        ThingId thingId = AcknowledgementsAdapter.getThingId(adaptable);
        return ThingAcknowledgementsFactory.newAcknowledgements((EntityId)thingId, AcknowledgementsAdapter.gatherContainedAcknowledgements(adaptable, thingId), (HttpStatus)AcknowledgementsAdapter.getHttpStatusOrThrow(adaptable), (DittoHeaders)adaptable.getDittoHeaders());
    }

    private static ThingId getThingId(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        return ThingId.of((String)topicPath.getNamespace(), (String)topicPath.getEntityName());
    }

    private static List<Acknowledgement> gatherContainedAcknowledgements(Adaptable adaptable, ThingId thingId) {
        JsonValue adaptablePayloadValue = adaptable.getPayload().getValue().orElseThrow(() -> (JsonMissingFieldException)JsonMissingFieldException.newBuilder().fieldName((CharSequence)Payload.JsonFields.VALUE.getPointer()).build());
        return AcknowledgementsAdapter.buildAcknowledgements(thingId, adaptablePayloadValue);
    }

    private static List<Acknowledgement> buildAcknowledgements(ThingId thingId, JsonValue value) {
        return value.asObject().stream().map(field -> {
            JsonObjectBuilder builder = field.getValue().asObject().toBuilder();
            builder.set(Acknowledgement.JsonFields.LABEL, (Object)field.getKey().toString()).set(Acknowledgement.JsonFields.ENTITY_ID, (Object)thingId.toString()).set(Acknowledgement.JsonFields.ENTITY_TYPE, (Object)ThingConstants.ENTITY_TYPE.toString());
            if (!field.getValue().asObject().contains((CharSequence)Acknowledgement.JsonFields.DITTO_HEADERS.getPointer())) {
                builder.set(Acknowledgement.JsonFields.DITTO_HEADERS, (Object)JsonObject.empty());
            }
            return Acknowledgement.fromJson((JsonObject)builder.build(), (DittoHeaders)DittoHeaders.empty());
        }).collect(Collectors.toList());
    }

    private static HttpStatus getHttpStatusOrThrow(Adaptable adaptable) {
        Payload payload = adaptable.getPayload();
        return payload.getHttpStatus().orElseThrow(() -> new JsonMissingFieldException(Payload.JsonFields.STATUS));
    }

    @Override
    public Adaptable toAdaptable(Acknowledgements acknowledgements, TopicPath.Channel channel) {
        return Adaptable.newBuilder(AcknowledgementsAdapter.getTopicPath(acknowledgements, channel)).withPayload(AcknowledgementsAdapter.getPayload(acknowledgements)).withHeaders(this.getExternalHeaders(acknowledgements.getDittoHeaders())).build();
    }

    @Override
    public TopicPath toTopicPath(Acknowledgements acknowledgements, TopicPath.Channel channel) {
        return AcknowledgementsAdapter.getTopicPath(acknowledgements, channel);
    }

    @Override
    public Set<TopicPath.Group> getGroups() {
        return EnumSet.of(TopicPath.Group.THINGS);
    }

    @Override
    public Set<TopicPath.Channel> getChannels() {
        return EnumSet.of(TopicPath.Channel.TWIN, TopicPath.Channel.LIVE);
    }

    @Override
    public Set<TopicPath.Criterion> getCriteria() {
        return EnumSet.of(TopicPath.Criterion.ACKS);
    }

    @Override
    public Set<TopicPath.Action> getActions() {
        return Collections.emptySet();
    }

    @Override
    public boolean isForResponses() {
        return true;
    }

    @Override
    public boolean requiresSubject() {
        return false;
    }

    private static TopicPath getTopicPath(Acknowledgements acknowledgement, TopicPath.Channel channel) {
        return AcknowledgementAdapter.getTopicPathBuilder(channel, acknowledgement.getEntityId()).aggregatedAcks().build();
    }

    private static Payload getPayload(Acknowledgements acknowledgements) {
        return Payload.newBuilder(JsonPointer.empty()).withStatus(acknowledgements.getHttpStatus()).withValue((JsonValue)AcknowledgementsAdapter.getPayloadValue(acknowledgements)).build();
    }

    private static JsonObject getPayloadValue(Acknowledgements acknowledgements) {
        return (JsonObject)acknowledgements.stream().map(ack -> JsonField.newInstance((CharSequence)ack.getLabel(), (JsonValue)AcknowledgementsAdapter.toJsonWithoutLabel(ack))).collect(JsonCollectors.fieldsToObject());
    }

    private static JsonObject toJsonWithoutLabel(Acknowledgement ack) {
        JsonObjectBuilder builder = JsonObject.newBuilder().set(Acknowledgement.JsonFields.STATUS_CODE, (Object)ack.getHttpStatus().getCode());
        ack.getEntity().ifPresent(payload -> builder.set(Acknowledgement.JsonFields.PAYLOAD, payload));
        if (!ack.getDittoHeaders().isEmpty()) {
            builder.set(Acknowledgement.JsonFields.DITTO_HEADERS, (Object)((JsonObject)ack.getDittoHeaders().toJson()));
        }
        return builder.build();
    }

    private DittoHeaders getExternalHeaders(DittoHeaders acknowledgementHeaders) {
        Map externalHeaders = this.headerTranslator.toExternalHeaders(acknowledgementHeaders);
        return ProtocolFactory.newHeadersWithJsonContentType(externalHeaders);
    }
}

