/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter.acknowledgements;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabel;
import org.eclipse.ditto.base.model.acks.DittoAcknowledgementLabel;
import org.eclipse.ditto.base.model.acks.DittoAcknowledgementLabelExternalUseForbiddenException;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.acks.Acknowledgement;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.AcknowledgementTopicPathBuilder;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.adapter.Adapter;
import org.eclipse.ditto.protocol.adapter.UnknownTopicPathException;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.signals.acks.ThingAcknowledgementFactory;

final class AcknowledgementAdapter
implements Adapter<Acknowledgement> {
    private final HeaderTranslator headerTranslator;

    private AcknowledgementAdapter(HeaderTranslator headerTranslator) {
        this.headerTranslator = headerTranslator;
    }

    static AcknowledgementAdapter getInstance(HeaderTranslator headerTranslator) {
        return new AcknowledgementAdapter((HeaderTranslator)ConditionChecker.checkNotNull((Object)headerTranslator, (String)"headerTranslator"));
    }

    static AcknowledgementTopicPathBuilder getTopicPathBuilder(TopicPath.Channel channel, EntityId entityId) {
        TopicPathBuilder topicPathBuilder = TopicPath.newBuilder(ThingId.of((CharSequence)entityId));
        if (TopicPath.Channel.TWIN == channel) {
            topicPathBuilder.twin();
        } else if (TopicPath.Channel.LIVE == channel) {
            topicPathBuilder.live();
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Unknown channel <{}>", new Object[]{channel}));
        }
        return topicPathBuilder.acks();
    }

    @Override
    public Acknowledgement fromAdaptable(Adaptable adaptable) {
        ConditionChecker.checkNotNull((Object)adaptable, (String)"adaptable");
        return ThingAcknowledgementFactory.newAcknowledgement((AcknowledgementLabel)AcknowledgementAdapter.getAcknowledgementLabel(adaptable), (ThingId)AcknowledgementAdapter.getThingId(adaptable), (HttpStatus)AcknowledgementAdapter.getHttpStatusOrThrow(adaptable), (DittoHeaders)adaptable.getDittoHeaders(), (JsonValue)AcknowledgementAdapter.getPayloadValueOrNull(adaptable));
    }

    private static ThingId getThingId(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        return ThingId.of((String)topicPath.getNamespace(), (String)topicPath.getEntityName());
    }

    private static HttpStatus getHttpStatusOrThrow(Adaptable adaptable) {
        Payload payload = adaptable.getPayload();
        return payload.getHttpStatus().orElseThrow(() -> new JsonMissingFieldException(Payload.JsonFields.STATUS));
    }

    private static AcknowledgementLabel getAcknowledgementLabel(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        return topicPath.getSubject().map(AcknowledgementLabel::of).map(ackLabel -> {
            if (DittoAcknowledgementLabel.contains((AcknowledgementLabel)ackLabel)) {
                throw new DittoAcknowledgementLabelExternalUseForbiddenException((CharSequence)ackLabel);
            }
            return ackLabel;
        }).orElseThrow(() -> (UnknownTopicPathException)UnknownTopicPathException.newBuilder(topicPath).description("Adaptable TopicPath for Acknowledgement did not contain required <subject> value").build());
    }

    @Nullable
    private static JsonValue getPayloadValueOrNull(Adaptable adaptable) {
        Payload payload = adaptable.getPayload();
        return payload.getValue().orElse(null);
    }

    @Override
    public Adaptable toAdaptable(Acknowledgement acknowledgement, TopicPath.Channel channel) {
        if (DittoAcknowledgementLabel.contains((AcknowledgementLabel)acknowledgement.getLabel())) {
            throw new DittoAcknowledgementLabelExternalUseForbiddenException((CharSequence)acknowledgement.getLabel());
        }
        return Adaptable.newBuilder(AcknowledgementAdapter.getTopicPath(acknowledgement, channel)).withPayload(AcknowledgementAdapter.getPayload(acknowledgement)).withHeaders(this.getExternalHeaders(acknowledgement.getDittoHeaders())).build();
    }

    @Override
    public TopicPath toTopicPath(Acknowledgement acknowledgement, TopicPath.Channel channel) {
        return AcknowledgementAdapter.getTopicPath(acknowledgement, channel);
    }

    @Override
    public Set<TopicPath.Group> getGroups() {
        return EnumSet.of(TopicPath.Group.THINGS);
    }

    @Override
    public Set<TopicPath.Channel> getChannels() {
        return EnumSet.of(TopicPath.Channel.TWIN, TopicPath.Channel.LIVE);
    }

    @Override
    public Set<TopicPath.Criterion> getCriteria() {
        return EnumSet.of(TopicPath.Criterion.ACKS);
    }

    @Override
    public Set<TopicPath.Action> getActions() {
        return Collections.emptySet();
    }

    @Override
    public boolean isForResponses() {
        return true;
    }

    @Override
    public boolean requiresSubject() {
        return true;
    }

    private static TopicPath getTopicPath(Acknowledgement acknowledgement, TopicPath.Channel channel) {
        return AcknowledgementAdapter.getTopicPathBuilder(channel, acknowledgement.getEntityId()).label((CharSequence)acknowledgement.getLabel()).build();
    }

    private static Payload getPayload(Acknowledgement acknowledgement) {
        return Payload.newBuilder(JsonPointer.empty()).withStatus(acknowledgement.getHttpStatus()).withValue(acknowledgement.getEntity(acknowledgement.getImplementedSchemaVersion()).orElse(null)).build();
    }

    private DittoHeaders getExternalHeaders(DittoHeaders acknowledgementHeaders) {
        Map externalHeaders = this.headerTranslator.toExternalHeaders(acknowledgementHeaders);
        return DittoHeaders.of((Map)externalHeaders);
    }
}

