/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.ProtocolAdapterException;
import org.eclipse.ditto.protocol.TopicPath;

@JsonParsableException(errorCode="protocoladapter:unknown.topicpath")
@Immutable
public final class UnknownTopicPathException
extends DittoRuntimeException
implements ProtocolAdapterException {
    public static final String ERROR_CODE = "protocoladapter:unknown.topicpath";
    private static final String MESSAGE_TEMPLATE = "The topic path ''{0}'' is not supported.";
    private static final String MESSAGE_TEMPLATE_WITH_PATH = "The topic ''{0}'' is not supported in combination with the path ''{1}''";
    private static final String DEFAULT_DESCRIPTION = "Check if the topic path is correct.";
    private static final long serialVersionUID = 5748920703966374167L;

    private UnknownTopicPathException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(TopicPath topicPath) {
        return new Builder(topicPath.getPath());
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public static UnknownTopicPathException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (UnknownTopicPathException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static UnknownTopicPathException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (UnknownTopicPathException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    static UnknownTopicPathException fromTopicAndPath(@Nullable TopicPath topicPath, @Nullable MessagePath path, @Nonnull DittoHeaders dittoHeaders) {
        String theTopicPath = null != topicPath ? topicPath.getPath() : "";
        String message = MessageFormat.format(MESSAGE_TEMPLATE_WITH_PATH, theTopicPath, path);
        return (UnknownTopicPathException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<UnknownTopicPathException> {
        private Builder() {
            this.description(UnknownTopicPathException.DEFAULT_DESCRIPTION);
        }

        private Builder(String path) {
            this();
            this.message(MessageFormat.format(UnknownTopicPathException.MESSAGE_TEMPLATE, path));
        }

        protected UnknownTopicPathException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new UnknownTopicPathException(dittoHeaders, message, description, cause, href);
        }
    }
}

