/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionEvent;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.AbstractStreamingMessageAdapter;
import org.eclipse.ditto.protocol.mapper.SignalMapperFactory;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategiesFactory;

public final class StreamingSubscriptionEventAdapter
extends AbstractStreamingMessageAdapter<StreamingSubscriptionEvent<?>> {
    private StreamingSubscriptionEventAdapter(HeaderTranslator headerTranslator, ErrorRegistry<?> errorRegistry) {
        super(MappingStrategiesFactory.getStreamingSubscriptionEventMappingStrategies(errorRegistry), SignalMapperFactory.newStreamingSubscriptionEventSignalMapper(), headerTranslator);
    }

    public static StreamingSubscriptionEventAdapter of(HeaderTranslator headerTranslator, ErrorRegistry<?> errorRegistry) {
        return new StreamingSubscriptionEventAdapter((HeaderTranslator)ConditionChecker.checkNotNull((Object)headerTranslator, (String)"headerTranslator"), (ErrorRegistry)ConditionChecker.checkNotNull(errorRegistry, (String)"errorRegistry"));
    }

    @Override
    protected String getType(Adaptable adaptable) {
        return "streaming.subscription.events:" + adaptable.getTopicPath().getStreamingAction().orElse(null);
    }

    @Override
    public Set<TopicPath.Criterion> getCriteria() {
        return EnumSet.of(TopicPath.Criterion.STREAMING);
    }

    @Override
    public Set<TopicPath.Action> getActions() {
        return Collections.emptySet();
    }

    @Override
    public boolean isForResponses() {
        return false;
    }

    @Override
    public Set<TopicPath.StreamingAction> getStreamingActions() {
        return EnumSet.of(TopicPath.StreamingAction.COMPLETE, TopicPath.StreamingAction.NEXT, TopicPath.StreamingAction.FAILED, TopicPath.StreamingAction.GENERATED);
    }

    @Override
    public boolean supportsWildcardTopics() {
        return false;
    }
}

