/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.commands.streaming.StreamingSubscriptionCommand;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.AbstractStreamingMessageAdapter;
import org.eclipse.ditto.protocol.mapper.SignalMapperFactory;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategiesFactory;

public final class StreamingSubscriptionCommandAdapter
extends AbstractStreamingMessageAdapter<StreamingSubscriptionCommand<?>> {
    private StreamingSubscriptionCommandAdapter(HeaderTranslator headerTranslator) {
        super(MappingStrategiesFactory.getStreamingSubscriptionCommandMappingStrategies(), SignalMapperFactory.newStreamingSubscriptionCommandSignalMapper(), headerTranslator);
    }

    public static StreamingSubscriptionCommandAdapter of(HeaderTranslator headerTranslator) {
        return new StreamingSubscriptionCommandAdapter((HeaderTranslator)ConditionChecker.checkNotNull((Object)headerTranslator, (String)"headerTranslator"));
    }

    @Override
    protected String getType(Adaptable adaptable) {
        return "streaming.subscription.commands:" + adaptable.getTopicPath().getStreamingAction().orElse(null);
    }

    @Override
    public Set<TopicPath.Criterion> getCriteria() {
        return EnumSet.of(TopicPath.Criterion.STREAMING);
    }

    @Override
    public Set<TopicPath.Action> getActions() {
        return Collections.emptySet();
    }

    @Override
    public boolean isForResponses() {
        return false;
    }

    @Override
    public Set<TopicPath.StreamingAction> getStreamingActions() {
        return EnumSet.of(TopicPath.StreamingAction.SUBSCRIBE_FOR_PERSISTED_EVENTS, TopicPath.StreamingAction.REQUEST, TopicPath.StreamingAction.CANCEL);
    }
}

