/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.base.model.signals.announcements.Announcement;
import org.eclipse.ditto.connectivity.model.signals.commands.ConnectivityCommand;
import org.eclipse.ditto.connectivity.model.signals.commands.ConnectivityCommandResponse;
import org.eclipse.ditto.connectivity.model.signals.events.ConnectivityEvent;
import org.eclipse.ditto.messages.model.signals.commands.MessageCommand;
import org.eclipse.ditto.messages.model.signals.commands.MessageCommandResponse;
import org.eclipse.ditto.policies.model.signals.commands.PolicyCommand;
import org.eclipse.ditto.policies.model.signals.commands.PolicyCommandResponse;
import org.eclipse.ditto.policies.model.signals.events.PolicyEvent;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.TopicPath;

public interface ProtocolAdapter {
    public Signal<?> fromAdaptable(Adaptable var1);

    public Adaptable toAdaptable(Signal<?> var1);

    public Adaptable toAdaptable(Signal<?> var1, TopicPath.Channel var2);

    public TopicPath toTopicPath(Signal<?> var1);

    public HeaderTranslator headerTranslator();

    public static boolean isLiveSignal(Signal<?> signal) {
        return signal.getDittoHeaders().getChannel().filter(TopicPath.Channel.LIVE.getName()::equals).isPresent();
    }

    public static TopicPath.Channel determineChannel(Signal<?> signal) {
        boolean isLiveSignal = ProtocolAdapter.isLiveSignal(signal);
        return isLiveSignal ? TopicPath.Channel.LIVE : ProtocolAdapter.determineDefaultChannel(signal);
    }

    public static TopicPath.Channel determineDefaultChannel(Signal<?> signal) {
        if (signal instanceof PolicyCommand || signal instanceof PolicyCommandResponse || signal instanceof PolicyEvent) {
            return TopicPath.Channel.NONE;
        }
        if (signal instanceof ConnectivityCommand || signal instanceof ConnectivityCommandResponse || signal instanceof ConnectivityEvent) {
            return TopicPath.Channel.NONE;
        }
        if (signal instanceof Announcement) {
            return TopicPath.Channel.NONE;
        }
        if (signal instanceof MessageCommand || signal instanceof MessageCommandResponse) {
            return TopicPath.Channel.LIVE;
        }
        return TopicPath.Channel.TWIN;
    }
}

