/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.ditto.base.model.headers.DittoHeaderDefinition;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.protocol.TopicPath;

public final class HeadersFromTopicPath {
    private HeadersFromTopicPath() {
    }

    public static DittoHeaders injectHeaders(DittoHeaders dittoHeaders, TopicPath topicPath, Extractor ... topicPathExtractors) {
        Map<String, String> headersFromTopicPath = Arrays.stream(topicPathExtractors).map(fn -> (Optional)fn.apply(topicPath)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return dittoHeaders.toBuilder().putHeaders(headersFromTopicPath).build();
    }

    private static Optional<String> getEntityId(TopicPath topicPath) {
        TopicPath.Group group = topicPath.getGroup();
        String namespace = topicPath.getNamespace();
        String entityName = topicPath.getEntityName();
        if (!"_".equals(namespace) && !"_".equals(entityName)) {
            return Optional.of(String.join((CharSequence)":", new CharSequence[]{group.getEntityType(), namespace, entityName}));
        }
        return Optional.empty();
    }

    public static interface Extractor
    extends Function<TopicPath, Optional<Map.Entry<String, String>>> {
        public static Optional<Map.Entry<String, String>> liveChannelExtractor(TopicPath topicPath) {
            if (topicPath.isChannel(TopicPath.Channel.LIVE)) {
                String key = DittoHeaderDefinition.CHANNEL.getKey();
                String value = TopicPath.Channel.LIVE.getName();
                return Optional.of(new AbstractMap.SimpleImmutableEntry<String, String>(key, value));
            }
            return Optional.empty();
        }

        public static Optional<Map.Entry<String, String>> entityIdExtractor(TopicPath topicPath) {
            return HeadersFromTopicPath.getEntityId(topicPath).map(entityId -> new AbstractMap.SimpleImmutableEntry<String, String>(DittoHeaderDefinition.ENTITY_ID.getKey(), (String)entityId));
        }
    }
}

