/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.exceptions.DittoJsonException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaderDefinition;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.base.model.signals.GlobalErrorRegistry;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.messages.model.MessageHeaderDefinition;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.Adapter;
import org.eclipse.ditto.protocol.adapter.AdapterResolver;
import org.eclipse.ditto.protocol.adapter.DefaultAdapterResolver;
import org.eclipse.ditto.protocol.adapter.ProtocolAdapter;
import org.eclipse.ditto.protocol.adapter.StreamingSubscriptionCommandAdapter;
import org.eclipse.ditto.protocol.adapter.StreamingSubscriptionEventAdapter;
import org.eclipse.ditto.protocol.adapter.acknowledgements.DefaultAcknowledgementsAdapterProvider;
import org.eclipse.ditto.protocol.adapter.connectivity.ConnectivityCommandAdapterProvider;
import org.eclipse.ditto.protocol.adapter.connectivity.DefaultConnectivityCommandAdapterProvider;
import org.eclipse.ditto.protocol.adapter.policies.DefaultPolicyCommandAdapterProvider;
import org.eclipse.ditto.protocol.adapter.provider.AcknowledgementAdapterProvider;
import org.eclipse.ditto.protocol.adapter.provider.PolicyCommandAdapterProvider;
import org.eclipse.ditto.protocol.adapter.provider.ThingCommandAdapterProvider;
import org.eclipse.ditto.protocol.adapter.things.DefaultThingCommandAdapterProvider;

public final class DittoProtocolAdapter
implements ProtocolAdapter {
    private final HeaderTranslator headerTranslator;
    private final ThingCommandAdapterProvider thingsAdapters;
    private final PolicyCommandAdapterProvider policiesAdapters;
    private final ConnectivityCommandAdapterProvider connectivityAdapters;
    private final AcknowledgementAdapterProvider acknowledgementAdapters;
    private final StreamingSubscriptionCommandAdapter streamingSubscriptionCommandAdapter;
    private final StreamingSubscriptionEventAdapter streamingSubscriptionEventAdapter;
    private final AdapterResolver adapterResolver;

    private DittoProtocolAdapter(ErrorRegistry<DittoRuntimeException> errorRegistry, HeaderTranslator headerTranslator) {
        this.headerTranslator = (HeaderTranslator)ConditionChecker.checkNotNull((Object)headerTranslator, (String)"headerTranslator");
        this.thingsAdapters = new DefaultThingCommandAdapterProvider(errorRegistry, headerTranslator);
        this.policiesAdapters = new DefaultPolicyCommandAdapterProvider(errorRegistry, headerTranslator);
        this.connectivityAdapters = new DefaultConnectivityCommandAdapterProvider(headerTranslator);
        this.acknowledgementAdapters = new DefaultAcknowledgementsAdapterProvider(errorRegistry, headerTranslator);
        this.streamingSubscriptionCommandAdapter = StreamingSubscriptionCommandAdapter.of(headerTranslator);
        this.streamingSubscriptionEventAdapter = StreamingSubscriptionEventAdapter.of(headerTranslator, errorRegistry);
        this.adapterResolver = new DefaultAdapterResolver(this.thingsAdapters, this.policiesAdapters, this.connectivityAdapters, this.acknowledgementAdapters, this.streamingSubscriptionCommandAdapter, this.streamingSubscriptionEventAdapter);
    }

    private DittoProtocolAdapter(HeaderTranslator headerTranslator, ThingCommandAdapterProvider thingsAdapters, PolicyCommandAdapterProvider policiesAdapters, ConnectivityCommandAdapterProvider connectivityAdapters, AcknowledgementAdapterProvider acknowledgementAdapters, StreamingSubscriptionCommandAdapter streamingSubscriptionCommandAdapter, StreamingSubscriptionEventAdapter streamingSubscriptionEventAdapter, AdapterResolver adapterResolver) {
        this.headerTranslator = (HeaderTranslator)ConditionChecker.checkNotNull((Object)headerTranslator, (String)"headerTranslator");
        this.thingsAdapters = (ThingCommandAdapterProvider)ConditionChecker.checkNotNull((Object)thingsAdapters, (String)"thingsAdapters");
        this.policiesAdapters = (PolicyCommandAdapterProvider)ConditionChecker.checkNotNull((Object)policiesAdapters, (String)"policiesAdapters");
        this.connectivityAdapters = (ConnectivityCommandAdapterProvider)ConditionChecker.checkNotNull((Object)connectivityAdapters, (String)"connectivityAdapters");
        this.acknowledgementAdapters = (AcknowledgementAdapterProvider)ConditionChecker.checkNotNull((Object)acknowledgementAdapters, (String)"acknowledgementAdapters");
        this.streamingSubscriptionCommandAdapter = (StreamingSubscriptionCommandAdapter)ConditionChecker.checkNotNull((Object)streamingSubscriptionCommandAdapter, (String)"streamingSubscriptionCommandAdapter");
        this.streamingSubscriptionEventAdapter = (StreamingSubscriptionEventAdapter)ConditionChecker.checkNotNull((Object)streamingSubscriptionEventAdapter, (String)"streamingSubscriptionEventAdapter");
        this.adapterResolver = (AdapterResolver)ConditionChecker.checkNotNull((Object)adapterResolver, (String)"adapterResolver");
    }

    public static DittoProtocolAdapter of(HeaderTranslator headerTranslator) {
        return new DittoProtocolAdapter((ErrorRegistry<DittoRuntimeException>)GlobalErrorRegistry.getInstance(), headerTranslator);
    }

    public static DittoProtocolAdapter newInstance() {
        return new DittoProtocolAdapter((ErrorRegistry<DittoRuntimeException>)GlobalErrorRegistry.getInstance(), DittoProtocolAdapter.getHeaderTranslator());
    }

    public static HeaderTranslator getHeaderTranslator() {
        return HeaderTranslator.of((HeaderDefinition[][])new HeaderDefinition[][]{DittoHeaderDefinition.values(), MessageHeaderDefinition.values()});
    }

    static DittoProtocolAdapter newInstance(HeaderTranslator headerTranslator, ThingCommandAdapterProvider thingCommandAdapterProvider, PolicyCommandAdapterProvider policyCommandAdapterProvider, ConnectivityCommandAdapterProvider connectivityAdapters, AcknowledgementAdapterProvider acknowledgementAdapters, StreamingSubscriptionCommandAdapter streamingSubscriptionCommandAdapter, StreamingSubscriptionEventAdapter streamingSubscriptionEventAdapter, AdapterResolver adapterResolver) {
        return new DittoProtocolAdapter(headerTranslator, thingCommandAdapterProvider, policyCommandAdapterProvider, connectivityAdapters, acknowledgementAdapters, streamingSubscriptionCommandAdapter, streamingSubscriptionEventAdapter, adapterResolver);
    }

    @Override
    public Signal<?> fromAdaptable(Adaptable adaptable) {
        Adapter<? extends Signal<?>> adapter = this.adapterResolver.getAdapter(adaptable);
        return (Signal)DittoJsonException.wrapJsonRuntimeException((Object)adaptable, (DittoHeaders)adaptable.getDittoHeaders(), (theAdaptable, headers) -> (Signal)adapter.fromAdaptable(adapter.validateAndPreprocess((Adaptable)theAdaptable)));
    }

    @Override
    public Adaptable toAdaptable(Signal<?> signal) {
        TopicPath.Channel channel = ProtocolAdapter.determineChannel(signal);
        return this.adapterResolver.getAdapter(signal, channel).toAdaptable(signal, channel);
    }

    @Override
    public Adaptable toAdaptable(Signal<?> signal, TopicPath.Channel channel) {
        return this.adapterResolver.getAdapter(signal, channel).toAdaptable(signal, channel);
    }

    @Override
    public HeaderTranslator headerTranslator() {
        return this.headerTranslator;
    }

    @Override
    public TopicPath toTopicPath(Signal<?> signal) {
        TopicPath.Channel channel = ProtocolAdapter.determineChannel(signal);
        return this.adapterResolver.getAdapter(signal, channel).toTopicPath(signal, channel);
    }
}

