/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.Adapter;
import org.eclipse.ditto.protocol.adapter.AdapterResolver;
import org.eclipse.ditto.protocol.adapter.AdapterResolverBySignal;
import org.eclipse.ditto.protocol.adapter.StreamingSubscriptionCommandAdapter;
import org.eclipse.ditto.protocol.adapter.StreamingSubscriptionEventAdapter;
import org.eclipse.ditto.protocol.adapter.UnknownTopicPathException;
import org.eclipse.ditto.protocol.adapter.connectivity.ConnectivityCommandAdapterProvider;
import org.eclipse.ditto.protocol.adapter.provider.AcknowledgementAdapterProvider;
import org.eclipse.ditto.protocol.adapter.provider.PolicyCommandAdapterProvider;
import org.eclipse.ditto.protocol.adapter.provider.ThingCommandAdapterProvider;

final class DefaultAdapterResolver
implements AdapterResolver {
    private final Function<Adaptable, Adapter<?>> resolver;
    private final AdapterResolverBySignal resolverBySignal;

    DefaultAdapterResolver(ThingCommandAdapterProvider thingsAdapters, PolicyCommandAdapterProvider policiesAdapters, ConnectivityCommandAdapterProvider connectivityAdapters, AcknowledgementAdapterProvider acknowledgementAdapters, StreamingSubscriptionCommandAdapter streamingSubscriptionCommandAdapter, StreamingSubscriptionEventAdapter streamingSubscriptionEventAdapter) {
        ArrayList adapters = new ArrayList();
        adapters.addAll(thingsAdapters.getAdapters());
        adapters.addAll(policiesAdapters.getAdapters());
        adapters.addAll(connectivityAdapters.getAdapters());
        adapters.addAll(acknowledgementAdapters.getAdapters());
        adapters.add(streamingSubscriptionCommandAdapter);
        adapters.add(streamingSubscriptionEventAdapter);
        this.resolver = DefaultAdapterResolver.computeResolver(adapters);
        this.resolverBySignal = new AdapterResolverBySignal(thingsAdapters, policiesAdapters, connectivityAdapters, acknowledgementAdapters, streamingSubscriptionCommandAdapter, streamingSubscriptionEventAdapter);
    }

    @Override
    public Adapter<? extends Signal<?>> getAdapter(Adaptable adaptable) {
        return this.resolver.apply(adaptable);
    }

    @Override
    public Adapter<Signal<?>> getAdapter(Signal<?> signal, TopicPath.Channel channel) {
        return this.resolverBySignal.resolve(signal, channel);
    }

    private static boolean isResponse(Adaptable adaptable) {
        return adaptable.getPayload().getHttpStatus().isPresent();
    }

    private static <T> List<T> filter(List<T> list, Predicate<T> predicate) {
        return list.stream().filter(predicate).collect(Collectors.toList());
    }

    private static <T> T throwUnknownTopicPathException(Adaptable adaptable) {
        throw (UnknownTopicPathException)UnknownTopicPathException.newBuilder(adaptable.getTopicPath()).build();
    }

    private static <T> T throwAmbiguityDetectedException(List<Adapter<?>> adapters) {
        throw new IllegalStateException("Indistinguishable adapters detected: " + adapters);
    }

    private static <S, T> Function<S, T> constantFunction(T result) {
        return ignored -> result;
    }

    private static <T extends Enum<T>> EnumMapOrFunction<T> dispatchByEnum(List<Adapter<?>> adapters, Class<T> enumClass, T[] enumValues, Function<Adapter<?>, Set<T>> enumExtractor, Function<List<Adapter<?>>, Function<Adaptable, Adapter<?>>> nextStage) {
        Map matchingAdaptersMap = Arrays.stream(enumValues).collect(Collectors.toMap(Function.identity(), enumValue -> DefaultAdapterResolver.filter(adapters, adapter -> ((Set)enumExtractor.apply((Adapter<?>)adapter)).contains(enumValue))));
        Optional matchingAdaptersMapHaveIdenticalValues = matchingAdaptersMap.values().stream().map(Optional::of).reduce((list1, list2) -> list1.equals(list2) ? list1 : Optional.empty()).flatMap(Function.identity());
        if (matchingAdaptersMapHaveIdenticalValues.isPresent()) {
            return new IsFunction(DefaultAdapterResolver.selectMatchedAdapters((List)matchingAdaptersMapHaveIdenticalValues.get(), nextStage));
        }
        EnumMap enumMap = new EnumMap(enumClass);
        matchingAdaptersMap.forEach((enumValue, matchingAdapters) -> enumMap.put((Object)enumValue, DefaultAdapterResolver.selectMatchedAdapters(matchingAdapters, nextStage)));
        return new IsEnumMap(enumMap);
    }

    private static Function<Adaptable, Adapter<?>> selectMatchedAdapters(List<Adapter<?>> matchingAdapters, Function<List<Adapter<?>>, Function<Adaptable, Adapter<?>>> nextStage) {
        if (matchingAdapters.isEmpty()) {
            return DefaultAdapterResolver::throwUnknownTopicPathException;
        }
        if (matchingAdapters.size() == 1) {
            return DefaultAdapterResolver.constantFunction(matchingAdapters.get(0));
        }
        return nextStage.apply(matchingAdapters);
    }

    private static <R, S extends Enum<S>, T> Function<R, T> evalEnumMapByOptional(EnumMap<S, Function<R, T>> enumMap, Function<R, T> emptyResult, Function<R, Optional<S>> optionalEnumExtractor) {
        return r -> {
            Optional optionalEnumValue = (Optional)optionalEnumExtractor.apply(r);
            if (optionalEnumValue.isPresent()) {
                return ((Function)enumMap.get(optionalEnumValue.get())).apply(r);
            }
            return emptyResult.apply(r);
        };
    }

    private static <R, S extends Enum<S>, T> Function<R, T> evalEnumMap(EnumMap<S, Function<R, T>> enumMap, Function<R, S> enumExtractor) {
        return r -> ((Function)enumMap.get(enumExtractor.apply(r))).apply(r);
    }

    private static <T> Function<Adaptable, T> forTopicPath(Function<TopicPath, T> extractor) {
        return extractor.compose(Adaptable::getTopicPath);
    }

    private static Function<Adaptable, Adapter<?>> computeResolverRecursively(List<Adapter<?>> adapters, Function<List<Adapter<?>>, Function<Adaptable, Adapter<?>>> finalStep, int i, List<ResolverStep> resolverSteps) {
        if (i >= resolverSteps.size()) {
            return finalStep.apply(adapters);
        }
        int j = i + 1;
        return resolverSteps.get(i).combine(adapters, nextAdapters -> DefaultAdapterResolver.computeResolverRecursively(nextAdapters, finalStep, j, resolverSteps));
    }

    private static Function<Adaptable, Adapter<?>> computeResolver(List<Adapter<?>> adapters) {
        return DefaultAdapterResolver.computeResolverRecursively(adapters, DefaultAdapterResolver::throwAmbiguityDetectedException, 0, Arrays.asList(new ForEnum(TopicPath.Group.class, TopicPath.Group.values(), Adapter::getGroups, DefaultAdapterResolver.forTopicPath(TopicPath::getGroup)), new ForEnum(TopicPath.Channel.class, TopicPath.Channel.values(), Adapter::getChannels, DefaultAdapterResolver.forTopicPath(TopicPath::getChannel)), new ForEnum(TopicPath.Criterion.class, TopicPath.Criterion.values(), Adapter::getCriteria, DefaultAdapterResolver.forTopicPath(TopicPath::getCriterion)), new ForEnumOptional(TopicPath.Action.class, TopicPath.Action.values(), Adapter::getActions, DefaultAdapterResolver.forTopicPath(TopicPath::getAction)), new ForEnumOptional(TopicPath.SearchAction.class, TopicPath.SearchAction.values(), Adapter::getSearchActions, DefaultAdapterResolver.forTopicPath(TopicPath::getSearchAction)), new ForEnumOptional(TopicPath.StreamingAction.class, TopicPath.StreamingAction.values(), Adapter::getStreamingActions, DefaultAdapterResolver.forTopicPath(TopicPath::getStreamingAction)), new ForEnum(Bool.class, Bool.values(), Bool.composeAsSet(Adapter::isForResponses), Bool.compose(DefaultAdapterResolver::isResponse)), new ForEnum(Bool.class, Bool.values(), Bool.composeAsSet(Adapter::requiresSubject), Bool.compose(adaptable -> adaptable.getTopicPath().getSubject().isPresent())), new ForEnum(Bool.class, Bool.values(), Bool.composeAsSet(Adapter::supportsWildcardTopics), Bool.compose(adaptable -> adaptable.getTopicPath().isWildcardTopic()))));
    }

    private static interface EnumMapOrFunction<T> {
        public Function<Adaptable, Adapter<?>> eval(Function<Adaptable, T> var1);

        public Function<Adaptable, Adapter<?>> evalByOptional(Function<Adaptable, Adapter<?>> var1, Function<Adaptable, Optional<T>> var2);
    }

    private static final class IsFunction<T>
    implements EnumMapOrFunction<T> {
        private final Function<Adaptable, Adapter<?>> function;

        private IsFunction(Function<Adaptable, Adapter<?>> function) {
            this.function = function;
        }

        @Override
        public Function<Adaptable, Adapter<?>> eval(Function<Adaptable, T> extractor) {
            return this.function;
        }

        @Override
        public Function<Adaptable, Adapter<?>> evalByOptional(Function<Adaptable, Adapter<?>> emptyResult, Function<Adaptable, Optional<T>> optionalEnumExtractor) {
            return r -> ((Optional)optionalEnumExtractor.apply((Adaptable)r)).isPresent() ? this.function.apply((Adaptable)r) : (Adapter<?>)emptyResult.apply((Adaptable)r);
        }
    }

    private static final class IsEnumMap<T extends Enum<T>>
    implements EnumMapOrFunction<T> {
        private final EnumMap<T, Function<Adaptable, Adapter<?>>> enumMap;

        private IsEnumMap(EnumMap<T, Function<Adaptable, Adapter<?>>> enumMap) {
            this.enumMap = enumMap;
        }

        @Override
        public Function<Adaptable, Adapter<?>> eval(Function<Adaptable, T> extractor) {
            return DefaultAdapterResolver.evalEnumMap(this.enumMap, extractor);
        }

        @Override
        public Function<Adaptable, Adapter<?>> evalByOptional(Function<Adaptable, Adapter<?>> emptyResult, Function<Adaptable, Optional<T>> optionalEnumExtractor) {
            return DefaultAdapterResolver.evalEnumMapByOptional(this.enumMap, emptyResult, optionalEnumExtractor);
        }
    }

    private static interface ResolverStep {
        public Function<Adaptable, Adapter<?>> combine(List<Adapter<?>> var1, Function<List<Adapter<?>>, Function<Adaptable, Adapter<?>>> var2);
    }

    private static final class ForEnum<T extends Enum<T>>
    implements ResolverStep {
        private final Class<T> enumClass;
        private final T[] enumValues;
        private final Function<Adapter<?>, Set<T>> getSupportedEnums;
        private final Function<Adaptable, T> extractEnum;

        private ForEnum(Class<T> enumClass, T[] enumValues, Function<Adapter<?>, Set<T>> getSupportedEnums, Function<Adaptable, T> extractEnum) {
            this.enumClass = enumClass;
            this.enumValues = enumValues;
            this.getSupportedEnums = getSupportedEnums;
            this.extractEnum = extractEnum;
        }

        @Override
        public Function<Adaptable, Adapter<?>> combine(List<Adapter<?>> currentAdapters, Function<List<Adapter<?>>, Function<Adaptable, Adapter<?>>> nextStep) {
            return ForEnum.forEnum(currentAdapters, this.enumClass, this.enumValues, this.getSupportedEnums, this.extractEnum, nextStep);
        }

        private static <T extends Enum<T>> Function<Adaptable, Adapter<?>> forEnum(List<Adapter<?>> adapters, Class<T> enumClass, T[] enumValues, Function<Adapter<?>, Set<T>> getSupportedEnums, Function<Adaptable, T> extractEnum, Function<List<Adapter<?>>, Function<Adaptable, Adapter<?>>> nextStep) {
            return DefaultAdapterResolver.dispatchByEnum((List)adapters, (Class)enumClass, (Enum[])enumValues, (Function)getSupportedEnums, (Function)nextStep).eval(extractEnum);
        }
    }

    private static final class ForEnumOptional<T extends Enum<T>>
    implements ResolverStep {
        private final Class<T> enumClass;
        private final T[] enumValues;
        private final Function<Adapter<?>, Set<T>> getSupportedEnums;
        private final Function<Adaptable, Optional<T>> extractEnum;

        private ForEnumOptional(Class<T> enumClass, T[] enumValues, Function<Adapter<?>, Set<T>> getSupportedEnums, Function<Adaptable, Optional<T>> extractEnum) {
            this.enumClass = enumClass;
            this.enumValues = enumValues;
            this.getSupportedEnums = getSupportedEnums;
            this.extractEnum = extractEnum;
        }

        @Override
        public Function<Adaptable, Adapter<?>> combine(List<Adapter<?>> currentAdapters, Function<List<Adapter<?>>, Function<Adaptable, Adapter<?>>> nextStep) {
            return ForEnumOptional.forEnumOptional(currentAdapters, this.enumClass, this.enumValues, this.getSupportedEnums, this.extractEnum, nextStep);
        }

        private static <T extends Enum<T>> Function<Adaptable, Adapter<?>> forEnumOptional(List<Adapter<?>> adapters, Class<T> enumClass, T[] enumValues, Function<Adapter<?>, Set<T>> getSupportedEnums, Function<Adaptable, Optional<T>> extractEnum, Function<List<Adapter<?>>, Function<Adaptable, Adapter<?>>> nextStep) {
            EnumMapOrFunction dispatchByT = DefaultAdapterResolver.dispatchByEnum((List)adapters, (Class)enumClass, (Enum[])enumValues, (Function)getSupportedEnums, (Function)nextStep);
            List noEnumValueAdapters = DefaultAdapterResolver.filter(adapters, adapter -> ((Set)getSupportedEnums.apply((Adapter<?>)adapter)).isEmpty());
            return dispatchByT.evalByOptional(nextStep.apply(noEnumValueAdapters), extractEnum);
        }
    }

    private static enum Bool {
        TRUE,
        FALSE;


        private static Bool of(boolean bool) {
            return bool ? TRUE : FALSE;
        }

        private static <T> Function<T, Bool> compose(Predicate<T> predicate) {
            return t -> Bool.of(predicate.test(t));
        }

        private static <T> Function<T, Set<Bool>> composeAsSet(Predicate<T> predicate) {
            return t -> EnumSet.of(Bool.of(predicate.test(t)));
        }
    }
}

