/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import java.util.Arrays;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.base.model.signals.acks.Acknowledgement;
import org.eclipse.ditto.base.model.signals.acks.Acknowledgements;
import org.eclipse.ditto.base.model.signals.commands.Command;
import org.eclipse.ditto.base.model.signals.commands.CommandResponse;
import org.eclipse.ditto.base.model.signals.commands.streaming.StreamingSubscriptionCommand;
import org.eclipse.ditto.base.model.signals.events.Event;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionEvent;
import org.eclipse.ditto.connectivity.model.signals.announcements.ConnectivityAnnouncement;
import org.eclipse.ditto.messages.model.signals.commands.MessageCommand;
import org.eclipse.ditto.messages.model.signals.commands.MessageCommandResponse;
import org.eclipse.ditto.policies.model.signals.announcements.PolicyAnnouncement;
import org.eclipse.ditto.policies.model.signals.commands.PolicyErrorResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.PolicyModifyCommand;
import org.eclipse.ditto.policies.model.signals.commands.modify.PolicyModifyCommandResponse;
import org.eclipse.ditto.policies.model.signals.commands.query.PolicyQueryCommand;
import org.eclipse.ditto.policies.model.signals.commands.query.PolicyQueryCommandResponse;
import org.eclipse.ditto.policies.model.signals.events.PolicyEvent;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.UnknownChannelException;
import org.eclipse.ditto.protocol.UnknownSignalException;
import org.eclipse.ditto.protocol.adapter.Adapter;
import org.eclipse.ditto.protocol.adapter.ProtocolAdapter;
import org.eclipse.ditto.protocol.adapter.StreamingSubscriptionCommandAdapter;
import org.eclipse.ditto.protocol.adapter.StreamingSubscriptionEventAdapter;
import org.eclipse.ditto.protocol.adapter.connectivity.ConnectivityCommandAdapterProvider;
import org.eclipse.ditto.protocol.adapter.provider.AcknowledgementAdapterProvider;
import org.eclipse.ditto.protocol.adapter.provider.PolicyCommandAdapterProvider;
import org.eclipse.ditto.protocol.adapter.provider.ThingCommandAdapterProvider;
import org.eclipse.ditto.things.model.signals.commands.ThingErrorResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.MergeThing;
import org.eclipse.ditto.things.model.signals.commands.modify.MergeThingResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ThingModifyCommand;
import org.eclipse.ditto.things.model.signals.commands.modify.ThingModifyCommandResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveThings;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveThingsResponse;
import org.eclipse.ditto.things.model.signals.commands.query.ThingQueryCommand;
import org.eclipse.ditto.things.model.signals.commands.query.ThingQueryCommandResponse;
import org.eclipse.ditto.things.model.signals.events.ThingEvent;
import org.eclipse.ditto.things.model.signals.events.ThingMerged;
import org.eclipse.ditto.thingsearch.model.signals.commands.SearchErrorResponse;
import org.eclipse.ditto.thingsearch.model.signals.commands.ThingSearchCommand;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionEvent;

final class AdapterResolverBySignal {
    private final ThingCommandAdapterProvider thingsAdapters;
    private final PolicyCommandAdapterProvider policiesAdapters;
    private final ConnectivityCommandAdapterProvider connectivityAdapters;
    private final AcknowledgementAdapterProvider acknowledgementAdapters;
    private final StreamingSubscriptionCommandAdapter streamingSubscriptionCommandAdapter;
    private final StreamingSubscriptionEventAdapter streamingSubscriptionEventAdapter;

    AdapterResolverBySignal(ThingCommandAdapterProvider thingsAdapters, PolicyCommandAdapterProvider policiesAdapters, ConnectivityCommandAdapterProvider connectivityAdapters, AcknowledgementAdapterProvider acknowledgementAdapters, StreamingSubscriptionCommandAdapter streamingSubscriptionCommandAdapter, StreamingSubscriptionEventAdapter streamingSubscriptionEventAdapter) {
        this.thingsAdapters = thingsAdapters;
        this.policiesAdapters = policiesAdapters;
        this.connectivityAdapters = connectivityAdapters;
        this.acknowledgementAdapters = acknowledgementAdapters;
        this.streamingSubscriptionCommandAdapter = streamingSubscriptionCommandAdapter;
        this.streamingSubscriptionEventAdapter = streamingSubscriptionEventAdapter;
    }

    <T extends Signal<?>> Adapter<T> resolve(T signal, TopicPath.Channel channel) {
        if (signal instanceof Event) {
            return this.resolveEvent((Event)signal, channel);
        }
        if (signal instanceof CommandResponse) {
            return this.resolveCommandResponse((CommandResponse)signal, channel);
        }
        if (signal instanceof Command) {
            return this.resolveCommand((Command)signal, channel);
        }
        if (signal instanceof PolicyAnnouncement) {
            this.validateChannel(channel, signal, TopicPath.Channel.NONE);
            return this.policiesAdapters.getAnnouncementAdapter();
        }
        if (signal instanceof ConnectivityAnnouncement) {
            this.validateChannel(channel, signal, TopicPath.Channel.NONE);
            return this.connectivityAdapters.getAnnouncementAdapter();
        }
        throw (UnknownSignalException)UnknownSignalException.newBuilder(signal.getName()).dittoHeaders(signal.getDittoHeaders()).build();
    }

    private <T extends Signal<?>> Adapter<T> resolveEvent(Event<?> event, TopicPath.Channel channel) {
        if (event instanceof ThingMerged) {
            this.validateChannel(channel, (Signal<?>)event, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.thingsAdapters.getMergedEventAdapter();
        }
        if (event instanceof ThingEvent) {
            this.validateChannel(channel, (Signal<?>)event, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.thingsAdapters.getEventAdapter();
        }
        if (event instanceof PolicyEvent) {
            this.validateChannel(channel, (Signal<?>)event, TopicPath.Channel.NONE);
            return this.policiesAdapters.getEventAdapter();
        }
        if (event instanceof SubscriptionEvent) {
            this.validateNotLive((Signal<?>)event);
            return this.thingsAdapters.getSubscriptionEventAdapter();
        }
        if (event instanceof StreamingSubscriptionEvent) {
            this.validateNotLive((Signal<?>)event);
            return this.streamingSubscriptionEventAdapter;
        }
        throw (UnknownSignalException)UnknownSignalException.newBuilder(event.getName()).dittoHeaders(event.getDittoHeaders()).build();
    }

    private <T extends Signal<?>> Adapter<T> resolveCommandResponse(CommandResponse<?> commandResponse, TopicPath.Channel channel) {
        if (commandResponse instanceof RetrieveThingsResponse) {
            this.validateChannel(channel, (Signal<?>)commandResponse, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.thingsAdapters.getRetrieveThingsCommandResponseAdapter();
        }
        if (commandResponse instanceof MergeThingResponse) {
            this.validateChannel(channel, (Signal<?>)commandResponse, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.thingsAdapters.getMergeCommandResponseAdapter();
        }
        if (commandResponse instanceof ThingModifyCommandResponse) {
            this.validateChannel(channel, (Signal<?>)commandResponse, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.thingsAdapters.getModifyCommandResponseAdapter();
        }
        if (commandResponse instanceof ThingQueryCommandResponse) {
            this.validateChannel(channel, (Signal<?>)commandResponse, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.thingsAdapters.getQueryCommandResponseAdapter();
        }
        if (commandResponse instanceof ThingErrorResponse) {
            this.validateChannel(channel, (Signal<?>)commandResponse, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.thingsAdapters.getErrorResponseAdapter();
        }
        if (commandResponse instanceof MessageCommandResponse) {
            this.validateChannel(channel, (Signal<?>)commandResponse, TopicPath.Channel.LIVE);
            return this.thingsAdapters.getMessageCommandResponseAdapter();
        }
        if (commandResponse instanceof PolicyModifyCommandResponse) {
            this.validateChannel(channel, (Signal<?>)commandResponse, TopicPath.Channel.NONE);
            return this.policiesAdapters.getModifyCommandResponseAdapter();
        }
        if (commandResponse instanceof PolicyQueryCommandResponse) {
            this.validateChannel(channel, (Signal<?>)commandResponse, TopicPath.Channel.NONE);
            return this.policiesAdapters.getQueryCommandResponseAdapter();
        }
        if (commandResponse instanceof PolicyErrorResponse) {
            this.validateChannel(channel, (Signal<?>)commandResponse, TopicPath.Channel.NONE);
            return this.policiesAdapters.getErrorResponseAdapter();
        }
        if (commandResponse instanceof SearchErrorResponse) {
            this.validateNotLive((Signal<?>)commandResponse);
            return this.thingsAdapters.getSearchErrorResponseAdapter();
        }
        if (commandResponse instanceof Acknowledgement) {
            this.validateChannel(channel, (Signal<?>)commandResponse, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.acknowledgementAdapters.getAcknowledgementAdapter();
        }
        if (commandResponse instanceof Acknowledgements) {
            this.validateChannel(channel, (Signal<?>)commandResponse, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.acknowledgementAdapters.getAcknowledgementsAdapter();
        }
        throw (UnknownSignalException)UnknownSignalException.newBuilder(commandResponse.getName()).dittoHeaders(commandResponse.getDittoHeaders()).build();
    }

    private <T extends Signal<?>> Adapter<T> resolveCommand(Command<?> command, TopicPath.Channel channel) {
        if (command instanceof MessageCommand) {
            this.validateChannel(channel, (Signal<?>)command, TopicPath.Channel.LIVE);
            return this.thingsAdapters.getMessageCommandAdapter();
        }
        if (command instanceof MergeThing) {
            this.validateChannel(channel, (Signal<?>)command, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.thingsAdapters.getMergeCommandAdapter();
        }
        if (command instanceof ThingModifyCommand) {
            this.validateChannel(channel, (Signal<?>)command, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.thingsAdapters.getModifyCommandAdapter();
        }
        if (command instanceof RetrieveThings) {
            this.validateChannel(channel, (Signal<?>)command, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.thingsAdapters.getRetrieveThingsCommandAdapter();
        }
        if (command instanceof ThingQueryCommand) {
            this.validateChannel(channel, (Signal<?>)command, TopicPath.Channel.LIVE, TopicPath.Channel.TWIN);
            return this.thingsAdapters.getQueryCommandAdapter();
        }
        if (command instanceof ThingSearchCommand) {
            this.validateNotLive((Signal<?>)command);
            return this.thingsAdapters.getSearchCommandAdapter();
        }
        if (command instanceof StreamingSubscriptionCommand) {
            this.validateNotLive((Signal<?>)command);
            return this.streamingSubscriptionCommandAdapter;
        }
        if (command instanceof PolicyModifyCommand) {
            this.validateChannel(channel, (Signal<?>)command, TopicPath.Channel.NONE);
            return this.policiesAdapters.getModifyCommandAdapter();
        }
        if (command instanceof PolicyQueryCommand) {
            this.validateChannel(channel, (Signal<?>)command, TopicPath.Channel.NONE);
            return this.policiesAdapters.getQueryCommandAdapter();
        }
        throw (UnknownSignalException)UnknownSignalException.newBuilder(command.getName()).dittoHeaders(command.getDittoHeaders()).build();
    }

    private void validateChannel(TopicPath.Channel channel, Signal<?> signal, TopicPath.Channel ... supportedChannels) {
        if (!Arrays.asList(supportedChannels).contains((Object)channel)) {
            throw this.unknownChannelException(signal, channel);
        }
    }

    private void validateNotLive(Signal<?> signal) {
        if (ProtocolAdapter.isLiveSignal(signal)) {
            throw this.unknownChannelException(signal, TopicPath.Channel.LIVE);
        }
    }

    private UnknownChannelException unknownChannelException(Signal<?> signal, TopicPath.Channel channel) {
        return (UnknownChannelException)UnknownChannelException.newBuilder(channel, signal.getType()).dittoHeaders(signal.getDittoHeaders()).build();
    }
}

