/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import java.util.Collections;
import java.util.Set;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;

public interface Adapter<T extends Jsonifiable<?>> {
    public T fromAdaptable(Adaptable var1);

    default public Adaptable toAdaptable(T t) {
        return this.toAdaptable(t, TopicPath.Channel.TWIN);
    }

    public Adaptable toAdaptable(T var1, TopicPath.Channel var2);

    public TopicPath toTopicPath(T var1, TopicPath.Channel var2);

    public Set<TopicPath.Group> getGroups();

    public Set<TopicPath.Channel> getChannels();

    public Set<TopicPath.Criterion> getCriteria();

    public Set<TopicPath.Action> getActions();

    default public Set<TopicPath.SearchAction> getSearchActions() {
        return Collections.emptySet();
    }

    default public Set<TopicPath.StreamingAction> getStreamingActions() {
        return Collections.emptySet();
    }

    public boolean isForResponses();

    default public boolean requiresSubject() {
        return false;
    }

    default public boolean supportsWildcardTopics() {
        return false;
    }

    default public Adaptable validateAndPreprocess(Adaptable adaptable) {
        MessagePath messagePath = adaptable.getPayload().getPath();
        JsonPointer parsedJsonPointer = JsonFactory.newPointer((CharSequence)messagePath.toString());
        return ProtocolFactory.newAdaptableBuilder(adaptable).withPayload(ProtocolFactory.toPayloadBuilder(adaptable.getPayload()).withPath(parsedJsonPointer).build()).build();
    }
}

