/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.AbstractAdapter;
import org.eclipse.ditto.protocol.adapter.Adapter;
import org.eclipse.ditto.protocol.adapter.EmptyPathMatcher;
import org.eclipse.ditto.protocol.mapper.SignalMapper;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategies;

abstract class AbstractStreamingMessageAdapter<T extends Signal<?>>
extends AbstractAdapter<T>
implements Adapter<T> {
    private final SignalMapper<T> signalMapper;

    AbstractStreamingMessageAdapter(MappingStrategies<T> mappingStrategies, SignalMapper<T> signalMapper, HeaderTranslator headerTranslator) {
        super(mappingStrategies, headerTranslator, EmptyPathMatcher.getInstance());
        this.signalMapper = signalMapper;
    }

    @Override
    protected Adaptable mapSignalToAdaptable(T signal, TopicPath.Channel channel) {
        return this.signalMapper.mapSignalToAdaptable(signal, channel);
    }

    @Override
    public Adaptable toAdaptable(T t) {
        return this.toAdaptable(t, TopicPath.Channel.LIVE);
    }

    @Override
    public TopicPath toTopicPath(T signal, TopicPath.Channel channel) {
        return this.signalMapper.mapSignalToTopicPath(signal, channel);
    }

    @Override
    public Set<TopicPath.Group> getGroups() {
        return EnumSet.of(TopicPath.Group.POLICIES, TopicPath.Group.THINGS, TopicPath.Group.CONNECTIONS);
    }

    @Override
    public Set<TopicPath.Channel> getChannels() {
        return EnumSet.of(TopicPath.Channel.NONE, TopicPath.Channel.TWIN);
    }
}

