/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.base.model.signals.commands.CommandResponse;
import org.eclipse.ditto.base.model.signals.commands.ErrorResponse;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuildable;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.adapter.ErrorResponseAdapter;
import org.eclipse.ditto.protocol.adapter.HeadersFromTopicPath;

public abstract class AbstractErrorResponseAdapter<T extends ErrorResponse<T>>
implements ErrorResponseAdapter<T> {
    private final HeaderTranslator headerTranslator;
    private final ErrorRegistry<DittoRuntimeException> errorRegistry;

    protected AbstractErrorResponseAdapter(HeaderTranslator headerTranslator, ErrorRegistry<DittoRuntimeException> errorRegistry) {
        this.headerTranslator = headerTranslator;
        this.errorRegistry = errorRegistry;
    }

    public static DittoRuntimeException parseWithErrorRegistry(JsonObject errorJson, DittoHeaders dittoHeaders, ErrorRegistry<?> errorRegistry) {
        return (DittoRuntimeException)((Object)errorRegistry.parse(errorJson, dittoHeaders));
    }

    @Override
    public T fromAdaptable(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        DittoHeaders dittoHeadersFromExternal = DittoHeaders.of((Map)this.headerTranslator.fromExternalHeaders((Map)adaptable.getDittoHeaders()));
        DittoHeaders dittoHeaders = HeadersFromTopicPath.injectHeaders(dittoHeadersFromExternal, topicPath, HeadersFromTopicPath.Extractor::liveChannelExtractor);
        DittoRuntimeException dittoRuntimeException = adaptable.getPayload().getValue().map(JsonValue::asObject).map(jsonObject -> AbstractErrorResponseAdapter.parseWithErrorRegistry(jsonObject, dittoHeaders, this.errorRegistry)).orElseThrow(() -> new JsonMissingFieldException(CommandResponse.JsonFields.PAYLOAD));
        return this.buildErrorResponse(topicPath, dittoRuntimeException, dittoRuntimeException.getDittoHeaders());
    }

    @Override
    public Adaptable toAdaptable(T errorResponse, TopicPath.Channel channel) {
        TopicPath topicPath = this.getTopicPath(errorResponse, channel);
        Payload payload = Payload.newBuilder(errorResponse.getResourcePath()).withStatus(errorResponse.getHttpStatus()).withValue((JsonValue)((JsonObject)errorResponse.toJson((Predicate)errorResponse.getImplementedSchemaVersion())).getValue(CommandResponse.JsonFields.PAYLOAD).orElse(JsonFactory.nullObject())).build();
        DittoHeaders responseHeaders = ProtocolFactory.newHeadersWithJsonContentType((Map<String, String>)errorResponse.getDittoHeaders());
        return Adaptable.newBuilder(topicPath).withPayload(payload).withHeaders(DittoHeaders.of((Map)this.headerTranslator.toExternalHeaders(responseHeaders))).build();
    }

    @Override
    public Set<TopicPath.Action> getActions() {
        return Collections.emptySet();
    }

    @Override
    public TopicPath toTopicPath(T t, TopicPath.Channel channel) {
        return this.getTopicPath(t, channel);
    }

    public abstract TopicPath getTopicPath(T var1, TopicPath.Channel var2);

    public abstract T buildErrorResponse(TopicPath var1, DittoRuntimeException var2, DittoHeaders var3);

    protected static TopicPathBuildable addChannelToTopicPathBuilder(TopicPathBuilder topicPathBuilder, TopicPath.Channel channel) {
        TopicPathBuildable topicPathBuildable;
        if (channel == TopicPath.Channel.TWIN) {
            topicPathBuildable = topicPathBuilder.twin().errors();
        } else if (channel == TopicPath.Channel.LIVE) {
            topicPathBuildable = topicPathBuilder.live().errors();
        } else if (channel == TopicPath.Channel.NONE) {
            topicPathBuildable = topicPathBuilder.none().errors();
        } else {
            throw new IllegalArgumentException("Unknown Channel '" + (Object)((Object)channel) + "'");
        }
        return topicPathBuildable;
    }
}

