/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.adapter;

import java.util.Map;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.exceptions.DittoJsonException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.translator.HeaderTranslator;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.PayloadPathMatcher;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.Adapter;
import org.eclipse.ditto.protocol.adapter.HeadersFromTopicPath;
import org.eclipse.ditto.protocol.adapter.UnknownTopicPathException;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategies;

public abstract class AbstractAdapter<T extends Jsonifiable.WithPredicate<JsonObject, JsonField>>
implements Adapter<T> {
    protected static final String RESPONSES_CRITERION = "responses";
    protected final PayloadPathMatcher payloadPathMatcher;
    private final MappingStrategies<T> mappingStrategies;
    private final HeaderTranslator headerTranslator;

    protected AbstractAdapter(MappingStrategies<T> mappingStrategies, HeaderTranslator headerTranslator, PayloadPathMatcher payloadPathMatcher) {
        this.mappingStrategies = (MappingStrategies)ConditionChecker.checkNotNull(mappingStrategies, (String)"mappingStrategies");
        this.headerTranslator = (HeaderTranslator)ConditionChecker.checkNotNull((Object)headerTranslator, (String)"headerTranslator");
        this.payloadPathMatcher = (PayloadPathMatcher)ConditionChecker.checkNotNull((Object)payloadPathMatcher, (String)"payloadPathMatcher");
    }

    @Override
    public final T fromAdaptable(Adaptable externalAdaptable) {
        ConditionChecker.checkNotNull((Object)externalAdaptable, (String)"externalAdaptable");
        String type = this.getType(externalAdaptable);
        DittoHeaders filteredHeaders = this.filterHeadersAndAddExtraHeadersFromTopicPath(externalAdaptable);
        JsonifiableMapper mapper = this.getJsonifiableMapperOrThrow(type, externalAdaptable, filteredHeaders);
        Adaptable adaptable = (Adaptable)externalAdaptable.setDittoHeaders(filteredHeaders);
        return (T)((Jsonifiable.WithPredicate)DittoJsonException.wrapJsonRuntimeException((Object)adaptable, (DittoHeaders)filteredHeaders, (theAdaptable, headers) -> (Jsonifiable.WithPredicate)mapper.map((Adaptable)theAdaptable)));
    }

    protected String getType(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        Payload adaptablePayload = adaptable.getPayload();
        MessagePath path = adaptablePayload.getPath();
        String commandName = (Object)((Object)AbstractAdapter.getActionOrThrow(topicPath)) + AbstractAdapter.upperCaseFirst(this.payloadPathMatcher.match(path));
        return (Object)((Object)topicPath.getGroup()) + "." + this.getTypeCriterionAsString(topicPath) + ":" + commandName;
    }

    private static TopicPath.Action getActionOrThrow(TopicPath topicPath) {
        return topicPath.getAction().orElseThrow(() -> new NullPointerException("TopicPath did not contain an Action!"));
    }

    private JsonifiableMapper<T> getJsonifiableMapperOrThrow(String type, Adaptable externalAdaptable, DittoHeaders filteredHeaders) {
        JsonifiableMapper<T> result = this.mappingStrategies.find(type);
        if (null == result) {
            Payload adaptablePayload = externalAdaptable.getPayload();
            throw UnknownTopicPathException.fromTopicAndPath(externalAdaptable.getTopicPath(), adaptablePayload.getPath(), filteredHeaders);
        }
        return result;
    }

    protected static String upperCaseFirst(String s) {
        String result;
        if (s.isEmpty()) {
            result = s;
        } else {
            char[] chars = s.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            result = new String(chars);
        }
        return result;
    }

    protected String getTypeCriterionAsString(TopicPath topicPath) {
        TopicPath.Criterion criterion = topicPath.getCriterion();
        return criterion.getName();
    }

    private DittoHeaders filterHeadersAndAddExtraHeadersFromTopicPath(Adaptable externalAdaptable) {
        DittoHeaders dittoHeadersFromExternal = DittoHeaders.of((Map)this.headerTranslator.fromExternalHeaders((Map)externalAdaptable.getDittoHeaders()));
        return HeadersFromTopicPath.injectHeaders(dittoHeadersFromExternal, externalAdaptable.getTopicPath(), HeadersFromTopicPath.Extractor::liveChannelExtractor, HeadersFromTopicPath.Extractor::entityIdExtractor);
    }

    @Override
    public final Adaptable toAdaptable(T signal, TopicPath.Channel channel) {
        Adaptable adaptable = this.mapSignalToAdaptable(signal, channel);
        Map externalHeaders = this.headerTranslator.toExternalHeaders(adaptable.getDittoHeaders());
        return (Adaptable)adaptable.setDittoHeaders(DittoHeaders.of((Map)externalHeaders));
    }

    protected abstract Adaptable mapSignalToAdaptable(T var1, TopicPath.Channel var2);

    protected Adaptable validateAndPreprocessMessagePathPrefix(Adaptable adaptable, int prefixLevel) {
        MessagePath messagePath = adaptable.getPayload().getPath();
        JsonPointer prefixPointer = messagePath.getPrefixPointer(prefixLevel).map(JsonPointer::toString).map(JsonFactory::newPointer).orElseGet(JsonPointer::empty);
        JsonPointer parsedMessagePath = prefixPointer.append(messagePath.getSubPointer(prefixLevel).orElseGet(JsonPointer::empty));
        return ProtocolFactory.newAdaptableBuilder(adaptable).withPayload(ProtocolFactory.toPayloadBuilder(adaptable.getPayload()).withPath(parsedMessagePath).build()).build();
    }
}

