/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.protocol.ProtocolAdapterException;

@JsonParsableException(errorCode="protocoladapter:unknown.signal")
public final class UnknownSignalException
extends DittoRuntimeException
implements ProtocolAdapterException {
    public static final String ERROR_CODE = "protocoladapter:unknown.signal";
    private static final String MESSAGE_TEMPLATE = "The signal ''{0}'' is not supported by the adapter.";
    private static final String DEFAULT_DESCRIPTION = "Check if the signal is correct.";
    private static final long serialVersionUID = -4379093157473087421L;

    private UnknownSignalException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String signalName) {
        return new Builder(signalName);
    }

    public static UnknownSignalException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (UnknownSignalException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static UnknownSignalException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (UnknownSignalException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<UnknownSignalException> {
        private Builder() {
            this.description(UnknownSignalException.DEFAULT_DESCRIPTION);
        }

        private Builder(String signalName) {
            this();
            this.message(MessageFormat.format(UnknownSignalException.MESSAGE_TEMPLATE, signalName));
        }

        protected UnknownSignalException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new UnknownSignalException(dittoHeaders, message, description, cause, href);
        }
    }
}

