/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.protocol.ProtocolAdapterException;

@JsonParsableException(errorCode="protocoladapter:unknown.path")
public final class UnknownPathException
extends DittoRuntimeException
implements ProtocolAdapterException {
    public static final String ERROR_CODE = "protocoladapter:unknown.path";
    private static final String MESSAGE_TEMPLATE = "The path ''{0}'' does not correspond to any known command, response or event.";
    private static final String DEFAULT_DESCRIPTION = "Check if the path is correct.";
    private static final long serialVersionUID = 3180803226245564305L;

    private UnknownPathException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(JsonPointer path) {
        return new Builder(path);
    }

    public static UnknownPathException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (UnknownPathException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static UnknownPathException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (UnknownPathException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<UnknownPathException> {
        private Builder() {
            this.description(UnknownPathException.DEFAULT_DESCRIPTION);
        }

        public Builder(JsonPointer path) {
            this();
            this.message(MessageFormat.format(UnknownPathException.MESSAGE_TEMPLATE, path.toString()));
        }

        protected UnknownPathException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new UnknownPathException(dittoHeaders, message, description, cause, href);
        }
    }
}

