/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.protocol.ProtocolAdapterException;

@JsonParsableException(errorCode="protocoladapter:unknown.command")
public final class UnknownCommandException
extends DittoRuntimeException
implements ProtocolAdapterException {
    public static final String ERROR_CODE = "protocoladapter:unknown.command";
    private static final String MESSAGE_TEMPLATE = "The command ''{0}'' is not supported by the adapter.";
    private static final String DEFAULT_DESCRIPTION = "Check if the command is correct.";
    private static final long serialVersionUID = 1359090043587487779L;

    private UnknownCommandException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String commandName) {
        return new Builder(commandName);
    }

    public static UnknownCommandException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (UnknownCommandException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static UnknownCommandException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (UnknownCommandException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<UnknownCommandException> {
        private Builder() {
            this.description(UnknownCommandException.DEFAULT_DESCRIPTION);
        }

        private Builder(String commandName) {
            this();
            this.message(MessageFormat.format(UnknownCommandException.MESSAGE_TEMPLATE, commandName));
        }

        protected UnknownCommandException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new UnknownCommandException(dittoHeaders, message, description, cause, href);
        }
    }
}

