/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.protocol.ProtocolAdapterException;
import org.eclipse.ditto.protocol.TopicPath;

@JsonParsableException(errorCode="protocoladapter:unknown.channel")
public final class UnknownChannelException
extends DittoRuntimeException
implements ProtocolAdapterException {
    public static final String ERROR_CODE = "protocoladapter:unknown.channel";
    private static final String MESSAGE_TEMPLATE = "The channel ''{0}'' is not supported in combination with signal type ''{1}''.";
    private static final String DEFAULT_DESCRIPTION = "Check if the channel is correct.";
    private static final long serialVersionUID = 2901292545115510591L;

    private UnknownChannelException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(TopicPath.Channel channel, String type) {
        return new Builder(channel, type);
    }

    public static UnknownChannelException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (UnknownChannelException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<UnknownChannelException> {
        private Builder() {
            this.description(UnknownChannelException.DEFAULT_DESCRIPTION);
        }

        private Builder(TopicPath.Channel channel, String type) {
            this();
            this.message(MessageFormat.format(UnknownChannelException.MESSAGE_TEMPLATE, channel.getName(), type));
        }

        protected UnknownChannelException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new UnknownChannelException(dittoHeaders, message, description, cause, href);
        }
    }
}

