/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.type.EntityType;
import org.eclipse.ditto.connectivity.model.ConnectionId;
import org.eclipse.ditto.connectivity.model.ConnectivityConstants;
import org.eclipse.ditto.policies.model.PolicyConstants;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.things.model.ThingConstants;
import org.eclipse.ditto.things.model.ThingId;

public interface TopicPath {
    public static final String ID_PLACEHOLDER = "_";
    public static final String PATH_DELIMITER = "/";

    public static TopicPathBuilder newBuilder(ThingId thingId) {
        return ProtocolFactory.newTopicPathBuilder(thingId);
    }

    public static TopicPathBuilder newBuilder(PolicyId policyId) {
        return ProtocolFactory.newTopicPathBuilder(policyId);
    }

    public static TopicPathBuilder newBuilder(ConnectionId connectionId) {
        return ProtocolFactory.newTopicPathBuilder((EntityId)connectionId);
    }

    public static TopicPathBuilder fromNamespace(String namespace) {
        return ProtocolFactory.newTopicPathBuilderFromNamespace(namespace);
    }

    public String getNamespace();

    public String getEntityName();

    public Group getGroup();

    public Channel getChannel();

    public Criterion getCriterion();

    public Optional<Action> getAction();

    public Optional<SearchAction> getSearchAction();

    public Optional<StreamingAction> getStreamingAction();

    public Optional<String> getSubject();

    public String getPath();

    default public boolean isWildcardTopic() {
        return ID_PLACEHOLDER.equals(this.getEntityName());
    }

    public boolean isGroup(@Nullable Group var1);

    public boolean isChannel(@Nullable Channel var1);

    public boolean isCriterion(@Nullable Criterion var1);

    public boolean isAction(@Nullable Action var1);

    public static enum StreamingAction {
        SUBSCRIBE_FOR_PERSISTED_EVENTS("subscribeForPersistedEvents"),
        CANCEL("cancel"),
        REQUEST("request"),
        COMPLETE("complete"),
        GENERATED("created"),
        FAILED("failed"),
        NEXT("next"),
        ERROR("error");

        private final String name;

        private StreamingAction(String name) {
            this.name = name;
        }

        public static Optional<StreamingAction> forName(String name) {
            return Stream.of(StreamingAction.values()).filter(a -> Objects.equals(a.getName(), name)).findFirst();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static enum SearchAction {
        SUBSCRIBE("subscribe"),
        CANCEL("cancel"),
        REQUEST("request"),
        COMPLETE("complete"),
        GENERATED("created"),
        FAILED("failed"),
        NEXT("next"),
        ERROR("error");

        private final String name;

        private SearchAction(String name) {
            this.name = name;
        }

        public static Optional<SearchAction> forName(String name) {
            return Stream.of(SearchAction.values()).filter(a -> Objects.equals(a.getName(), name)).findFirst();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static enum Action {
        CREATE("create"),
        RETRIEVE("retrieve"),
        MODIFY("modify"),
        MERGE("merge"),
        DELETE("delete"),
        CREATED("created"),
        MODIFIED("modified"),
        MERGED("merged"),
        DELETED("deleted");

        private final String name;

        private Action(String name) {
            this.name = name;
        }

        public static Optional<Action> forName(String name) {
            return Stream.of(Action.values()).filter(a -> Objects.equals(a.getName(), name)).findFirst();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Channel {
        TWIN("twin"),
        LIVE("live"),
        NONE("none");

        private final String name;

        private Channel(String name) {
            this.name = name;
        }

        public static Optional<Channel> forName(String name) {
            return Stream.of(Channel.values()).filter(a -> Objects.equals(a.getName(), name)).findFirst();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static enum Criterion {
        COMMANDS("commands"),
        EVENTS("events"),
        SEARCH("search"),
        MESSAGES("messages"),
        ERRORS("errors"),
        ACKS("acks"),
        ANNOUNCEMENTS("announcements"),
        STREAMING("streaming");

        private final String name;

        private Criterion(String name) {
            this.name = name;
        }

        public static Optional<Criterion> forName(String name) {
            return Stream.of(Criterion.values()).filter(a -> Objects.equals(a.getName(), name)).findFirst();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static enum Group {
        POLICIES("policies", PolicyConstants.ENTITY_TYPE),
        THINGS("things", ThingConstants.ENTITY_TYPE),
        CONNECTIONS("connections", ConnectivityConstants.ENTITY_TYPE);

        private final String name;
        private final EntityType entityType;

        private Group(String name, EntityType entityType) {
            this.name = name;
            this.entityType = entityType;
        }

        public static Optional<Group> forName(String name) {
            return Stream.of(Group.values()).filter(a -> Objects.equals(a.getName(), name)).findFirst();
        }

        public String getName() {
            return this.name;
        }

        public EntityType getEntityType() {
            return this.entityType;
        }

        public String toString() {
            return this.getName();
        }
    }
}

