/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.id.NamespacedEntityId;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.contenttype.ContentType;
import org.eclipse.ditto.connectivity.model.ConnectivityConstants;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.policies.model.PolicyConstants;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.AdaptableBuilder;
import org.eclipse.ditto.protocol.ImmutableAdaptableBuilder;
import org.eclipse.ditto.protocol.ImmutableJsonifiableAdaptable;
import org.eclipse.ditto.protocol.ImmutablePayload;
import org.eclipse.ditto.protocol.ImmutableTopicPath;
import org.eclipse.ditto.protocol.JsonifiableAdaptable;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.things.model.ThingConstants;
import org.eclipse.ditto.things.model.ThingId;

public final class ProtocolFactory {
    private ProtocolFactory() {
        throw new AssertionError();
    }

    public static AdaptableBuilder newAdaptableBuilder(TopicPath topicPath) {
        return ImmutableAdaptableBuilder.of(topicPath);
    }

    public static AdaptableBuilder newAdaptableBuilder(Adaptable existingAdaptable) {
        return ImmutableAdaptableBuilder.of(existingAdaptable.getTopicPath()).withPayload(existingAdaptable.getPayload()).withHeaders(existingAdaptable.getDittoHeaders());
    }

    public static Adaptable setExtra(Adaptable existingAdaptable, JsonObject extra) {
        return ProtocolFactory.newAdaptableBuilder(existingAdaptable).withPayload(Payload.newBuilder(existingAdaptable.getPayload()).withExtra(extra).build()).build();
    }

    public static TopicPath newTopicPath(String topicPathString) {
        return ImmutableTopicPath.parseTopicPath(topicPathString);
    }

    public static TopicPathBuilder newTopicPathBuilder(ThingId thingId) {
        ConditionChecker.checkNotNull((Object)thingId, (String)"thingId");
        TopicPathBuilder result = ImmutableTopicPath.newBuilder(thingId.getNamespace(), thingId.getName());
        return result.things();
    }

    public static TopicPathBuilder newTopicPathBuilder(NamespacedEntityId entityId) {
        ConditionChecker.checkNotNull((Object)entityId, (String)"entityId");
        TopicPathBuilder result = ImmutableTopicPath.newBuilder(entityId.getNamespace(), entityId.getName());
        if (entityId.getEntityType().equals((Object)ThingConstants.ENTITY_TYPE)) {
            return result.things();
        }
        if (entityId.getEntityType().equals((Object)PolicyConstants.ENTITY_TYPE)) {
            return result.policies();
        }
        return result;
    }

    public static TopicPathBuilder newTopicPathBuilder(EntityId entityId) {
        TopicPathBuilder result;
        ConditionChecker.checkNotNull((Object)entityId, (String)"entityId");
        if (entityId instanceof NamespacedEntityId) {
            String namespace = ((NamespacedEntityId)entityId).getNamespace();
            String name = ((NamespacedEntityId)entityId).getName();
            result = ImmutableTopicPath.newBuilder(namespace, name);
        } else {
            result = ProtocolFactory.newTopicPathBuilderFromName(entityId.toString());
        }
        if (entityId.getEntityType().equals((Object)ThingConstants.ENTITY_TYPE)) {
            return result.things();
        }
        if (entityId.getEntityType().equals((Object)PolicyConstants.ENTITY_TYPE)) {
            return result.policies();
        }
        if (entityId.getEntityType().equals((Object)ConnectivityConstants.ENTITY_TYPE)) {
            return result.connections();
        }
        return result;
    }

    public static TopicPathBuilder newTopicPathBuilder(PolicyId policyId) {
        ConditionChecker.checkNotNull((Object)policyId, (String)"policyId");
        TopicPathBuilder result = ImmutableTopicPath.newBuilder(policyId.getNamespace(), policyId.getName());
        return result.policies();
    }

    public static TopicPathBuilder newTopicPathBuilderFromNamespace(String namespace) {
        TopicPathBuilder result = ImmutableTopicPath.newBuilder(namespace, "_");
        return result.things();
    }

    public static TopicPathBuilder newTopicPathBuilderFromName(String name) {
        return ImmutableTopicPath.newBuilder("_", name);
    }

    public static Payload newPayload(String jsonString) {
        return ProtocolFactory.newPayload(JsonFactory.newObject((String)jsonString));
    }

    public static Payload newPayload(JsonObject jsonObject) {
        return ImmutablePayload.fromJson(jsonObject);
    }

    public static PayloadBuilder newPayloadBuilder() {
        return ProtocolFactory.newPayloadBuilder(JsonPointer.empty());
    }

    public static PayloadBuilder newPayloadBuilder(JsonPointer path) {
        return ImmutablePayload.getBuilder(path);
    }

    public static PayloadBuilder toPayloadBuilder(Payload payload) {
        return new ImmutablePayload.ImmutablePayloadBuilder(payload);
    }

    public static DittoHeaders emptyHeaders() {
        return DittoHeaders.empty();
    }

    public static DittoHeaders newHeadersWithDittoContentType(Map<String, String> headers) {
        return DittoHeaders.newBuilder(headers).contentType((CharSequence)"application/vnd.eclipse.ditto+json").build();
    }

    public static DittoHeaders newHeadersWithJsonContentType(Map<String, String> headers) {
        return DittoHeaders.newBuilder(headers).contentType(ContentType.APPLICATION_JSON).build();
    }

    public static DittoHeaders newHeadersWithJsonMergePatchContentType(Map<String, String> headers) {
        return DittoHeaders.newBuilder(headers).contentType(ContentType.APPLICATION_MERGE_PATCH_JSON).build();
    }

    public static DittoHeaders newHeaders(Collection<Map.Entry<String, String>> headers) {
        return DittoHeaders.of(headers.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public static DittoHeaders newHeaders(JsonObject headersAsJson) {
        return DittoHeaders.newBuilder((JsonObject)headersAsJson).build();
    }

    public static JsonifiableAdaptable wrapAsJsonifiableAdaptable(Adaptable adaptable) {
        return ImmutableJsonifiableAdaptable.of(adaptable);
    }

    public static JsonifiableAdaptable jsonifiableAdaptableFromJson(JsonObject adaptableAsJson) {
        return ImmutableJsonifiableAdaptable.fromJson(adaptableAsJson);
    }
}

