/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.entity.metadata.Metadata;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;

public interface Payload
extends Jsonifiable<JsonObject> {
    public static PayloadBuilder newBuilder(JsonPointer path) {
        return ProtocolFactory.newPayloadBuilder(path);
    }

    public static PayloadBuilder newBuilder() {
        return ProtocolFactory.newPayloadBuilder();
    }

    public static PayloadBuilder newBuilder(Payload payload) {
        ConditionChecker.checkNotNull((Object)payload, (String)"payload");
        PayloadBuilder result = Payload.newBuilder(payload.getPath()).withValue(payload.getValue().orElse(null)).withExtra(payload.getExtra().orElse(null)).withStatus(payload.getHttpStatus().orElse(null)).withTimestamp(payload.getTimestamp().orElse(null)).withFields((JsonFieldSelector)payload.getFields().orElse(null));
        payload.getRevision().ifPresent(result::withRevision);
        return result;
    }

    public MessagePath getPath();

    public Optional<JsonValue> getValue();

    public Optional<JsonObject> getExtra();

    public Optional<HttpStatus> getHttpStatus();

    public Optional<Long> getRevision();

    public Optional<Instant> getTimestamp();

    public Optional<Metadata> getMetadata();

    public Optional<JsonFieldSelector> getFields();

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<String> PATH = JsonFactory.newStringFieldDefinition((CharSequence)"path", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<JsonValue> VALUE = JsonFactory.newJsonValueFieldDefinition((CharSequence)"value", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<JsonObject> EXTRA = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"extra", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<Integer> STATUS = JsonFactory.newIntFieldDefinition((CharSequence)"status", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<Long> REVISION = JsonFactory.newLongFieldDefinition((CharSequence)"revision", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<String> TIMESTAMP = JsonFactory.newStringFieldDefinition((CharSequence)"timestamp", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<JsonObject> METADATA = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"metadata", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<String> FIELDS = JsonFactory.newStringFieldDefinition((CharSequence)"fields", (JsonFieldMarker[])new JsonFieldMarker[0]);

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

